/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.kotlinx.coroutines;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.kotlinx.coroutines.ExecutorCoroutineDispatcherBase;
import org.jetbrains.kotlin.kotlinx.coroutines.PoolThread;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0005H\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/kotlinx/coroutines/ThreadPoolDispatcher;", "Lorg/jetbrains/kotlin/kotlinx/coroutines/ExecutorCoroutineDispatcherBase;", "nThreads", "", "name", "", "(ILjava/lang/String;)V", "executor", "Ljava/util/concurrent/Executor;", "getExecutor", "()Ljava/util/concurrent/Executor;", "threadNo", "Ljava/util/concurrent/atomic/AtomicInteger;", "close", "", "toString", "kotlinx-coroutines-core"})
public final class ThreadPoolDispatcher
extends ExecutorCoroutineDispatcherBase {
    private final AtomicInteger threadNo;
    @NotNull
    private final Executor executor;
    private final int nThreads;
    private final String name;

    @Override
    @NotNull
    public Executor getExecutor() {
        return this.executor;
    }

    @Override
    public void close() {
        Executor executor2 = this.getExecutor();
        if (executor2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.concurrent.ExecutorService");
        }
        ((ExecutorService)executor2).shutdown();
    }

    @Override
    @NotNull
    public String toString() {
        return "ThreadPoolDispatcher[" + this.nThreads + ", " + this.name + ']';
    }

    public ThreadPoolDispatcher(int nThreads, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        this.nThreads = nThreads;
        this.name = name;
        this.threadNo = new AtomicInteger();
        ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(this.nThreads, new ThreadFactory(this){
            final /* synthetic */ ThreadPoolDispatcher this$0;

            @NotNull
            public final PoolThread newThread(Runnable target) {
                Runnable runnable = target;
                Intrinsics.checkExpressionValueIsNotNull((Object)runnable, (String)"target");
                return new PoolThread(this.this$0, runnable, ThreadPoolDispatcher.access$getNThreads$p(this.this$0) == 1 ? ThreadPoolDispatcher.access$getName$p(this.this$0) : ThreadPoolDispatcher.access$getName$p(this.this$0) + "-" + ThreadPoolDispatcher.access$getThreadNo$p(this.this$0).incrementAndGet());
            }
            {
                this.this$0 = threadPoolDispatcher;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)scheduledExecutorService, (String)"Executors.newScheduledTh\u2026.incrementAndGet())\n    }");
        this.executor = scheduledExecutorService;
        this.initFutureCancellation$kotlinx_coroutines_core();
    }

    public static final /* synthetic */ int access$getNThreads$p(ThreadPoolDispatcher $this) {
        return $this.nThreads;
    }

    @NotNull
    public static final /* synthetic */ String access$getName$p(ThreadPoolDispatcher $this) {
        return $this.name;
    }

    @NotNull
    public static final /* synthetic */ AtomicInteger access$getThreadNo$p(ThreadPoolDispatcher $this) {
        return $this.threadNo;
    }
}

