/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.containers;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.util.Consumer;
import org.jetbrains.kotlin.com.intellij.util.containers.ShareableKey;
import org.jetbrains.kotlin.com.intellij.util.containers.hash.EqualityPolicy;
import org.jetbrains.kotlin.com.intellij.util.containers.hash.LinkedHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SLRUMap<K, V> {
    protected final LinkedHashMap<K, V> myProtectedQueue;
    protected final LinkedHashMap<K, V> myProbationalQueue;
    private final int myProtectedQueueSize;
    private final int myProbationalQueueSize;
    private int probationalHits = 0;
    private int protectedHits = 0;
    private int misses = 0;
    private static final int FACTOR = Integer.getInteger("idea.slru.factor", 1);

    public SLRUMap(int protectedQueueSize, int probationalQueueSize) {
        this(protectedQueueSize, probationalQueueSize, EqualityPolicy.CANONICAL);
    }

    public SLRUMap(int protectedQueueSize, int probationalQueueSize, EqualityPolicy hashingStrategy) {
        this.myProtectedQueueSize = protectedQueueSize * FACTOR;
        this.myProbationalQueueSize = probationalQueueSize * FACTOR;
        this.myProtectedQueue = new LinkedHashMap<K, V>(10, 0.6f, hashingStrategy, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, V> eldest, K key, V value) {
                if (this.size() > SLRUMap.this.myProtectedQueueSize) {
                    SLRUMap.this.myProbationalQueue.put(key, value);
                    return true;
                }
                return false;
            }
        };
        this.myProbationalQueue = new LinkedHashMap<K, V>(10, 0.6f, hashingStrategy, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, V> eldest, K key, V value) {
                if (this.size() > SLRUMap.this.myProbationalQueueSize) {
                    SLRUMap.this.onDropFromCache(key, value);
                    return true;
                }
                return false;
            }
        };
    }

    @Nullable
    public V get(K key) {
        V value = this.myProtectedQueue.get(key);
        if (value != null) {
            ++this.protectedHits;
            return value;
        }
        value = this.myProbationalQueue.remove(key);
        if (value != null) {
            ++this.probationalHits;
            this.putToProtectedQueue(key, value);
            return value;
        }
        ++this.misses;
        return null;
    }

    protected void putToProtectedQueue(K key, V value) {
        this.myProtectedQueue.put(this.getStableKey(key), value);
    }

    public void put(K key, @NotNull V value) {
        V oldValue;
        if (value == null) {
            SLRUMap.$$$reportNull$$$0(0);
        }
        if ((oldValue = this.myProtectedQueue.remove(key)) != null) {
            this.onDropFromCache(key, oldValue);
        }
        if ((oldValue = this.myProbationalQueue.put(this.getStableKey(key), value)) != null) {
            this.onDropFromCache(key, oldValue);
        }
    }

    protected void onDropFromCache(K key, V value) {
    }

    public boolean remove(K key) {
        V value = this.myProtectedQueue.remove(key);
        if (value != null) {
            this.onDropFromCache(key, value);
            return true;
        }
        value = this.myProbationalQueue.remove(key);
        if (value != null) {
            this.onDropFromCache(key, value);
            return true;
        }
        return false;
    }

    public void iterateKeys(Consumer<K> keyConsumer) {
        for (K key : this.myProtectedQueue.keySet()) {
            keyConsumer.consume(key);
        }
        for (K key : this.myProbationalQueue.keySet()) {
            keyConsumer.consume(key);
        }
    }

    public Set<Map.Entry<K, V>> entrySet() {
        HashSet<Map.Entry<K, V>> set = new HashSet<Map.Entry<K, V>>(this.myProtectedQueue.entrySet());
        set.addAll(this.myProbationalQueue.entrySet());
        return set;
    }

    public void clear() {
        try {
            if (!this.myProtectedQueue.isEmpty()) {
                for (Map.Entry<K, V> entry : this.myProtectedQueue.entrySet()) {
                    this.onDropFromCache(entry.getKey(), entry.getValue());
                }
            }
            if (!this.myProbationalQueue.isEmpty()) {
                for (Map.Entry<K, V> entry : this.myProbationalQueue.entrySet()) {
                    this.onDropFromCache(entry.getKey(), entry.getValue());
                }
            }
        }
        finally {
            this.myProtectedQueue.clear();
            this.myProbationalQueue.clear();
        }
    }

    protected K getStableKey(K key) {
        if (key instanceof ShareableKey) {
            return (K)((ShareableKey)key).getStableCopy();
        }
        return key;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/com/intellij/util/containers/SLRUMap", "put"));
    }
}

