/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.api;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.shrinkwrap.api.ClassLoaderSearchUtil;
import org.jboss.shrinkwrap.api.Configuration;
import org.jboss.shrinkwrap.api.ExtensionLoader;
import org.jboss.shrinkwrap.api.SecurityActions;

public class ConfigurationBuilder {
    private static final Logger log = Logger.getLogger(ConfigurationBuilder.class.getName());
    private static final String EXTENSION_LOADER_IMPL = "org.jboss.shrinkwrap.impl.base.ServiceExtensionLoader";
    private ExtensionLoader extensionLoader;
    private ExecutorService executorService;
    private Iterable<ClassLoader> classLoaders;

    public ExtensionLoader getExtensionLoader() {
        return this.extensionLoader;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public Iterable<ClassLoader> getClassLoaders() {
        return this.classLoaders;
    }

    public ConfigurationBuilder extensionLoader(ExtensionLoader extensionLoader) {
        this.extensionLoader = extensionLoader;
        return this;
    }

    public ConfigurationBuilder executorService(ExecutorService executorService) {
        this.executorService = executorService;
        return this;
    }

    public ConfigurationBuilder classLoaders(Iterable<ClassLoader> classLoaders) {
        this.classLoaders = classLoaders;
        return this;
    }

    public Configuration build() {
        return new Configuration(this);
    }

    void setDefaults() {
        if (this.getClassLoaders() == null) {
            ClassLoader tccl = SecurityActions.getThreadContextClassLoader();
            if (log.isLoggable(Level.FINER)) {
                log.finer("User has not defined an explicit " + ClassLoader.class.getSimpleName() + "; defaulting to the TCCL: " + tccl);
            }
            ArrayList tcclCollection = new ArrayList(1);
            if (tccl != null) {
                tcclCollection.add(tccl);
            } else {
                tcclCollection.add(ClassLoader.getSystemClassLoader());
            }
            this.classLoaders = tcclCollection;
        }
        HashSet<ClassLoader> adjustedCls = new HashSet<ClassLoader>();
        for (ClassLoader cl : this.classLoaders) {
            if (cl == null) {
                cl = ClassLoader.getSystemClassLoader();
            }
            adjustedCls.add(cl);
        }
        this.classLoaders = adjustedCls;
        if (this.getExtensionLoader() == null) {
            ExtensionLoader loader = this.createDefaultExtensionLoader();
            if (log.isLoggable(Level.FINER)) {
                log.finer("User has not defined an explicit " + ExtensionLoader.class.getSimpleName() + "; defaulting to " + loader);
            }
            this.extensionLoader(loader);
        }
    }

    ExtensionLoader createDefaultExtensionLoader() {
        Class<?> extensionLoaderImplClass;
        try {
            extensionLoaderImplClass = ClassLoaderSearchUtil.findClassFromClassLoaders(EXTENSION_LOADER_IMPL, this.getClassLoaders());
        }
        catch (ClassNotFoundException cnfe) {
            throw new IllegalStateException("Could not find extension loader impl class in any of the configured ClassLoaders", cnfe);
        }
        return SecurityActions.newInstance(extensionLoaderImplClass, new Class[]{Iterable.class}, new Object[]{this.getClassLoaders()}, ExtensionLoader.class);
    }
}

