/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.tck.tests.internal;

import javax.money.CurrencyUnit;
import javax.money.MonetaryAmount;
import javax.money.MonetaryAmountFactory;
import javax.money.MonetaryContext;
import javax.money.MonetaryCurrencies;
import javax.money.NumberValue;
import org.javamoney.tck.tests.internal.TestAmount;

public final class TestMonetaryAmountBuilder
implements MonetaryAmountFactory<TestAmount> {
    private Number value;
    private CurrencyUnit currency;

    public static TestAmount getAmount(Number number, CurrencyUnit currency) {
        return new TestAmount(number, currency);
    }

    public Class<? extends MonetaryAmount> getAmountType() {
        return TestAmount.class;
    }

    public MonetaryAmountFactory<TestAmount> setCurrency(String currencyCode) {
        this.currency = MonetaryCurrencies.getCurrency((String)currencyCode, (String[])new String[0]);
        return this;
    }

    public MonetaryAmountFactory<TestAmount> setCurrency(CurrencyUnit currency) {
        this.currency = currency;
        return this;
    }

    public MonetaryAmountFactory<TestAmount> setNumber(double number) {
        this.value = number;
        return this;
    }

    public MonetaryAmountFactory<TestAmount> setNumber(long number) {
        this.value = number;
        return this;
    }

    public MonetaryAmountFactory<TestAmount> setNumber(Number number) {
        this.value = number;
        return this;
    }

    public NumberValue getMaxNumber() {
        return null;
    }

    public NumberValue getMinNumber() {
        return null;
    }

    public MonetaryAmountFactory<TestAmount> setContext(MonetaryContext monetaryContext) {
        return this;
    }

    public MonetaryAmountFactory<TestAmount> setAmount(MonetaryAmount amount) {
        this.setCurrency(amount.getCurrency());
        this.setNumber((Number)amount.getNumber());
        return this;
    }

    public TestAmount create() {
        return new TestAmount(this.value, this.currency);
    }

    public MonetaryContext getDefaultMonetaryContext() {
        return TestAmount.MONETARY_CONTEXT;
    }

    public MonetaryContext getMaximalMonetaryContext() {
        return TestAmount.MONETARY_CONTEXT;
    }
}

