/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.tck.tests.internal;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Objects;
import javax.money.CurrencyUnit;
import javax.money.MonetaryAmount;
import javax.money.MonetaryAmountFactory;
import javax.money.MonetaryContext;
import javax.money.MonetaryContextBuilder;
import javax.money.MonetaryCurrencies;
import javax.money.MonetaryException;
import javax.money.MonetaryOperator;
import javax.money.MonetaryQuery;
import javax.money.NumberValue;
import org.javamoney.tck.tests.internal.TestNumberValue;

public final class TestAmount
implements MonetaryAmount,
Serializable {
    private BigDecimal value;
    private CurrencyUnit currencyUnit;
    public static final MonetaryContext MONETARY_CONTEXT = MonetaryContextBuilder.of().setAmountType(TestAmount.class).setMaxScale(-1).setPrecision(0).build();

    public TestAmount(Number number, CurrencyUnit currency) {
        this.currencyUnit = currency;
        this.value = new BigDecimal(String.valueOf(number));
    }

    public MonetaryAmount with(MonetaryOperator operator) {
        try {
            return (MonetaryAmount)operator.apply((Object)this);
        }
        catch (MonetaryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MonetaryException("Exception during operator execution.", (Throwable)e);
        }
    }

    public MonetaryAmountFactory<? extends MonetaryAmount> getFactory() {
        return new MonetaryAmountFactory<TestAmount>(){
            private CurrencyUnit currency;
            private BigDecimal number;
            {
                this.currency = TestAmount.this.currencyUnit;
                this.number = TestAmount.this.value;
            }

            public Class<? extends MonetaryAmount> getAmountType() {
                return TestAmount.class;
            }

            public MonetaryAmountFactory setCurrency(String currencyCode) {
                this.currency = MonetaryCurrencies.getCurrency((String)currencyCode, (String[])new String[0]);
                return this;
            }

            public MonetaryAmountFactory setCurrency(CurrencyUnit currency) {
                Objects.requireNonNull(currency);
                this.currency = currency;
                return this;
            }

            public MonetaryAmountFactory setNumber(double number) {
                Objects.requireNonNull(number);
                this.number = new BigDecimal(String.valueOf(number));
                return this;
            }

            public MonetaryAmountFactory setNumber(long number) {
                Objects.requireNonNull(number);
                this.number = new BigDecimal(String.valueOf(number));
                return this;
            }

            public MonetaryAmountFactory setNumber(Number number) {
                Objects.requireNonNull(number);
                this.number = new BigDecimal(String.valueOf(number));
                return this;
            }

            public NumberValue getMaxNumber() {
                return null;
            }

            public NumberValue getMinNumber() {
                return null;
            }

            public MonetaryAmountFactory setContext(MonetaryContext monetaryContext) {
                return this;
            }

            public MonetaryAmountFactory setAmount(MonetaryAmount amount) {
                this.currency = amount.getCurrency();
                this.number = (BigDecimal)amount.getNumber().numberValue(BigDecimal.class);
                return this;
            }

            public TestAmount create() {
                return new TestAmount(this.number, this.currency);
            }

            public MonetaryContext getDefaultMonetaryContext() {
                return MONETARY_CONTEXT;
            }

            public MonetaryContext getMaximalMonetaryContext() {
                return MONETARY_CONTEXT;
            }
        };
    }

    public MonetaryAmount subtract(MonetaryAmount amount) {
        return this;
    }

    public MonetaryAmount stripTrailingZeros() {
        this.value = this.value.stripTrailingZeros();
        return this;
    }

    public int signum() {
        return this.value.signum();
    }

    public MonetaryAmount add(MonetaryAmount amount) {
        return null;
    }

    public MonetaryAmount scaleByPowerOfTen(int power) {
        return this;
    }

    public MonetaryAmount abs() {
        return null;
    }

    public MonetaryAmount remainder(Number divisor) {
        return this;
    }

    public MonetaryAmount[] divideAndRemainder(long divisor) {
        return new MonetaryAmount[0];
    }

    public MonetaryAmount[] divideAndRemainder(double divisor) {
        return new MonetaryAmount[0];
    }

    public MonetaryAmount[] divideAndRemainder(Number divisor) {
        return new MonetaryAmount[0];
    }

    public MonetaryAmount divideToIntegralValue(long divisor) {
        return null;
    }

    public MonetaryAmount divideToIntegralValue(double divisor) {
        return null;
    }

    public MonetaryAmount divideToIntegralValue(Number divisor) {
        return null;
    }

    public MonetaryAmount remainder(double divisor) {
        return this;
    }

    public MonetaryAmount remainder(long divisor) {
        return this;
    }

    public <R> R query(MonetaryQuery<R> query) {
        return (R)query.queryFrom((MonetaryAmount)this);
    }

    public MonetaryAmount plus() {
        return this;
    }

    public MonetaryAmount negate() {
        return this;
    }

    public MonetaryAmount multiply(Number multiplicand) {
        return new TestAmount(this.value.multiply(new BigDecimal(String.valueOf(multiplicand))), this.getCurrency());
    }

    public MonetaryAmount divide(long divisor) {
        return null;
    }

    public MonetaryAmount divide(double divisor) {
        return null;
    }

    public MonetaryAmount divide(Number divisor) {
        return null;
    }

    public MonetaryAmount multiply(double multiplicand) {
        return this;
    }

    public MonetaryAmount multiply(long multiplicand) {
        return this;
    }

    public boolean isZero() {
        return false;
    }

    public boolean isPositiveOrZero() {
        return true;
    }

    public boolean isPositive() {
        return true;
    }

    public boolean isNegativeOrZero() {
        return false;
    }

    public boolean isNegative() {
        return false;
    }

    public boolean isLessThanOrEqualTo(MonetaryAmount amount) {
        return this.value.stripTrailingZeros().compareTo(((BigDecimal)amount.getNumber().numberValue(BigDecimal.class)).stripTrailingZeros()) == 0;
    }

    public boolean isLessThan(MonetaryAmount amount) {
        return this.value.stripTrailingZeros().compareTo(((BigDecimal)amount.getNumber().numberValue(BigDecimal.class)).stripTrailingZeros()) < 0;
    }

    public boolean isGreaterThanOrEqualTo(MonetaryAmount amount) {
        return this.value.stripTrailingZeros().compareTo(((BigDecimal)amount.getNumber().numberValue(BigDecimal.class)).stripTrailingZeros()) >= 0;
    }

    public boolean isGreaterThan(MonetaryAmount amount) {
        return this.value.stripTrailingZeros().compareTo(((BigDecimal)amount.getNumber().numberValue(BigDecimal.class)).stripTrailingZeros()) > 0;
    }

    public boolean isEqualTo(MonetaryAmount amount) {
        return this.value.stripTrailingZeros().compareTo(((BigDecimal)amount.getNumber().numberValue(BigDecimal.class)).stripTrailingZeros()) == 0;
    }

    public CurrencyUnit getCurrency() {
        return this.currencyUnit;
    }

    public MonetaryContext getMonetaryContext() {
        return MONETARY_CONTEXT;
    }

    public int compareTo(MonetaryAmount o) {
        return 0;
    }

    public String toString() {
        return this.currencyUnit.getCurrencyCode() + ' ' + String.valueOf(this.value);
    }

    public NumberValue getNumber() {
        return new TestNumberValue(this.value);
    }
}

