/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.tck.tests.format;

import java.text.DecimalFormat;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.money.CurrencyUnit;
import javax.money.MonetaryAmount;
import javax.money.MonetaryAmountFactory;
import javax.money.MonetaryAmounts;
import javax.money.MonetaryCurrencies;
import javax.money.MonetaryException;
import javax.money.format.AmountFormatQuery;
import javax.money.format.AmountFormatQueryBuilder;
import javax.money.format.MonetaryAmountFormat;
import javax.money.format.MonetaryFormats;
import org.javamoney.tck.tests.internal.TestAmount;
import org.javamoney.tck.tests.internal.TestMonetaryAmountBuilder;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@SpecVersion(spec="JSR 354", version="1.0.0")
public class FormattingMonetaryAmountsTest {
    @Test(description="4.4.1 Ensures the system.s default locale is supported for MonetaryAmountFormat.")
    @SpecAssertion(section="4.4.1", id="441-A1")
    public void testNoDepOnAmountImplementation() {
        Locale defaultLocale = Locale.getDefault();
        MonetaryAmountFormat amountFormat = MonetaryFormats.getAmountFormat((Locale)defaultLocale, (String[])new String[0]);
        Number[] values = new Number[]{100, 10000000000000L};
        for (CurrencyUnit currency : MonetaryCurrencies.getCurrencies((String[])new String[0])) {
            for (Number value : values) {
                MonetaryAmount amount = MonetaryAmounts.getDefaultAmountFactory().setCurrency(currency.getCurrencyCode()).setNumber(value).create();
                String formattedAmount = amountFormat.format(amount);
                TestAmount amountMock = TestMonetaryAmountBuilder.getAmount(value, currency);
                String formattedAmountMock = amountFormat.format((MonetaryAmount)amountMock);
                AssertJUnit.assertNotNull((Object)formattedAmountMock);
                Assert.assertEquals((String)formattedAmountMock, (String)formattedAmount);
            }
        }
    }

    @Test(description="4.4.1 Formats amounts using all available locales.")
    @SpecAssertion(section="4.4.1", id="441-A2")
    public void testFormattingIsIndependentOfImplementation() {
        for (Locale locale : MonetaryFormats.getAvailableLocales((String[])new String[0])) {
            MonetaryAmountFormat format = MonetaryFormats.getAmountFormat((Locale)locale, (String[])new String[0]);
            HashSet<String> formatsProcuced = new HashSet<String>();
            for (MonetaryAmountFactory fact : MonetaryAmounts.getAmountFactories()) {
                if (fact.getAmountType().equals(TestAmount.class)) continue;
                MonetaryAmount amt = fact.setCurrency("USD").setNumber(10.5).create();
                String formatProduced = format.format(amt);
                Assert.assertNotNull((Object)formatProduced, (String)("No MonetaryAmountFormat returned from MonetaryFormats.getMonetaryFormat(Locale,String...) with supported Locale: " + locale));
                Assert.assertFalse((boolean)formatProduced.isEmpty(), (String)("MonetaryAmountFormat returned empty String for " + amt));
                formatsProcuced.add(formatProduced);
            }
            Assert.assertFalse((boolean)formatsProcuced.isEmpty(), (String)"No formatted amount available. Are there no amount?");
            Assert.assertFalse((formatsProcuced.size() > 1 ? 1 : 0) != 0, (String)("Formatter produces different output for different amount classes(+" + format.getClass() + "): " + formatsProcuced));
        }
    }

    @Test(description="4.4.1 Test formats and parses (round-trip) any supported amount type for each supported Locale.")
    @SpecAssertion(section="4.4.1", id="441-A3")
    public void testParseIsIndependentOfImplementation() {
        for (Locale locale : MonetaryFormats.getAvailableLocales((String[])new String[0])) {
            MonetaryAmountFormat format = MonetaryFormats.getAmountFormat((Locale)locale, (String[])new String[0]);
            for (MonetaryAmountFactory fact : MonetaryAmounts.getAmountFactories()) {
                if (fact.getAmountType().equals(TestAmount.class)) continue;
                MonetaryAmount amt = fact.setCurrency("USD").setNumber(10.5).create();
                String formatProduced = format.format(amt);
                Assert.assertNotNull((Object)formatProduced, (String)("No MonetaryAmountFormat returned from MonetaryFormats.getMonetaryFormat(Locale,String...) with supported Locale: " + locale));
                Assert.assertFalse((boolean)formatProduced.isEmpty(), (String)("MonetaryAmountFormat returned empty String for " + amt));
                try {
                    MonetaryAmount amtParsed = format.parse((CharSequence)formatProduced);
                    Assert.assertNotNull((Object)amtParsed, (String)("Reverse-parsing of MonetaryAmount failed for '" + formatProduced + "' using MonetaryAmountFormat: " + format));
                }
                catch (MonetaryException e) {
                    System.out.println("WARNING: Reverse-parsing of MonetaryAmount failed for '" + formatProduced + "' using MonetaryAmountFormat: " + format);
                }
            }
        }
    }

    @Test(description="4.4.1 Test formats and parses (round-trip) any supported amount type for each supported Locale, using different format queries.")
    @SpecAssertion(section="4.4.1", id="441-A4")
    public void testParseDifferentStyles() {
        for (Locale locale : MonetaryFormats.getAvailableLocales((String[])new String[0])) {
            for (Class clazz : MonetaryAmounts.getAmountTypes()) {
                if (clazz.equals(TestAmount.class)) continue;
                MonetaryAmountFactory fact = MonetaryAmounts.getAmountFactory((Class)clazz);
                AmountFormatQuery query = AmountFormatQueryBuilder.of((Locale)locale).setMonetaryAmountFactory(fact).build();
                if (fact.getAmountType().equals(TestAmount.class)) continue;
                MonetaryAmount amt = fact.setCurrency("USD").setNumber(10.5).create();
                MonetaryAmountFormat format = MonetaryFormats.getAmountFormat((AmountFormatQuery)query);
                String formatProduced = format.format(amt);
                Assert.assertNotNull((Object)formatProduced, (String)("No MonetaryAmountFormat returned from MonetaryFormats.getMonetaryFormat(Locale,String...) with supported Locale: " + locale));
                Assert.assertFalse((boolean)formatProduced.isEmpty(), (String)("MonetaryAmountFormat returned empty String for " + amt));
                try {
                    MonetaryAmount amtParsed = format.parse((CharSequence)formatProduced);
                    Assert.assertNotNull((Object)amtParsed, (String)("Reverse-parsing of MonetaryAmount failed for '" + formatProduced + "' using MonetaryAmountFormat: " + format));
                    Assert.assertEquals(amtParsed.getClass(), (Object)clazz, (String)("Reverse-parsing of MonetaryAmount failed for '" + formatProduced + "' using MonetaryAmountFormat(invalid type " + amtParsed.getClass().getName() + ") for format: " + format));
                }
                catch (MonetaryException e) {
                    System.out.println("WARNING: Reverse-parsing of MonetaryAmount failed for '" + formatProduced + "' using MonetaryAmountFormat: " + format);
                }
            }
        }
    }

    @Test(description="4.4.1 Test formats and parses (round-trip) any supported amount type for each supported Locale, checks results for different currencies")
    @SpecAssertion(section="4.4.1", id="441-A6")
    public void testParseWithDifferentCurrencies() {
        for (Locale locale : MonetaryFormats.getAvailableLocales((String[])new String[0])) {
            MonetaryAmountFormat format = MonetaryFormats.getAmountFormat((Locale)locale, (String[])new String[0]);
            for (MonetaryAmountFactory fact : MonetaryAmounts.getAmountFactories()) {
                if (fact.getAmountType().equals(TestAmount.class)) continue;
                for (String currency : new String[]{"CHF", "USD", "GBP", "EUR"}) {
                    MonetaryAmount amt = fact.setCurrency(currency).setNumber(10.5).create();
                    String formatProduced = format.format(amt);
                    Assert.assertNotNull((Object)formatProduced, (String)("No MonetaryAmountFormat returned from MonetaryFormats.getMonetaryFormat(Locale,String...) with supported Locale: " + locale));
                    Assert.assertFalse((boolean)formatProduced.isEmpty(), (String)("MonetaryAmountFormat returned empty String for " + amt));
                    try {
                        MonetaryAmount amtParsed = format.parse((CharSequence)formatProduced);
                        Assert.assertNotNull((Object)amtParsed, (String)("Reverse-parsing of MonetaryAmount failed for '" + formatProduced + "' using MonetaryAmountFormat: " + format));
                        Assert.assertEquals((String)amtParsed.getCurrency().getCurrencyCode(), (String)currency, (String)("Reverse-parsing of MonetaryAmount failed for '" + formatProduced + "' using MonetaryAmountFormat(invalid currency " + amtParsed.getCurrency().getCurrencyCode() + "): " + format));
                    }
                    catch (MonetaryException e) {
                        System.out.println("WARNING: Reverse-parsing of MonetaryAmount failed for '" + formatProduced + "' using MonetaryAmountFormat: " + format);
                    }
                }
            }
        }
    }

    @Test(description="4.4.1 Ensures all Locales defined by DecimalFormat.getAvailableLocales() are available for monetary formatting.")
    @SpecAssertion(section="4.4.1", id="441-B1")
    public void testLocalesSupported() {
        Locale[] jdkDecimalFormatLocales;
        for (Locale jdkDecimalFormatLocale : jdkDecimalFormatLocales = DecimalFormat.getAvailableLocales()) {
            MonetaryAmountFormat amountFormat = MonetaryFormats.getAmountFormat((Locale)jdkDecimalFormatLocale, (String[])new String[0]);
            AssertJUnit.assertNotNull((Object)amountFormat);
            Assert.assertEquals((Object)jdkDecimalFormatLocale, (Object)amountFormat.getAmountFormatContext().getLocale());
        }
    }

    @Test(description="4.4.1 Ensures for each locale defined by DecimalFormat.getAvailableLocales() a MonetaryAmountFormat instance is provided.")
    @SpecAssertion(section="4.4.1", id="441-B2")
    public void testGetAmountFormat() {
        for (Locale locale : DecimalFormat.getAvailableLocales()) {
            AssertJUnit.assertNotNull((Object)MonetaryFormats.getAmountFormat((AmountFormatQuery)AmountFormatQuery.of((Locale)locale, (String[])new String[0])));
        }
    }

    @Test(description="4.4.1 Ensures for each locale defined by DecimalFormat.getAvailableLocales() a MonetaryFormats.isAvailable(Locale) is true.")
    @SpecAssertion(section="4.4.1", id="441-B3")
    public void testGetAvailableLocales() {
        Set locales = MonetaryFormats.getAvailableLocales((String[])new String[0]);
        for (Locale locale : DecimalFormat.getAvailableLocales()) {
            if (Locale.ROOT.equals(locale)) continue;
            AssertJUnit.assertTrue((String)("MonetaryFormats.getAvailableLocales(); Locale supported by JDKs DecimalFormat is not available: " + locale), (boolean)locales.contains(locale));
        }
    }

    @Test(description="4.4.1 Ensures for each locale defined by DecimalFormat.getAvailableLocales() a MonetaryFormats.getAmountFormat(AmountFormatQuery) returns a formatter.")
    @SpecAssertion(section="4.4.1", id="441-B3")
    public void testAmountStyleOf() {
        for (Locale locale : DecimalFormat.getAvailableLocales()) {
            AssertJUnit.assertNotNull((Object)MonetaryFormats.getAmountFormat((AmountFormatQuery)AmountFormatQuery.of((Locale)locale, (String[])new String[0])));
        }
    }
}

