/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.tck.tests.conversion;

import javax.money.CurrencyUnit;
import javax.money.MonetaryCurrencies;
import javax.money.MonetaryException;
import javax.money.convert.ConversionContext;
import javax.money.convert.ConversionQuery;
import javax.money.convert.ConversionQueryBuilder;
import javax.money.convert.CurrencyConversion;
import javax.money.convert.ExchangeRateProvider;
import javax.money.convert.MonetaryConversions;
import javax.money.convert.ProviderContext;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@SpecVersion(spec="JSR 354", version="1.0.0")
public class MonetaryConversionsTest {
    @Test(description="4.3.1 Ensure at least one conversion provider is available, TestRateProvider must be present.")
    @SpecAssertion(id="431-A1", section="4.3.1")
    public void testProvidersAvailable() {
        int providerCount = 0;
        for (String providername : MonetaryConversions.getProviderNames()) {
            if ("TestRateProvider".equals(providername)) continue;
            ++providerCount;
        }
        AssertJUnit.assertTrue((String)"At least one conversion provider must be available/registered.", (providerCount > 0 ? 1 : 0) != 0);
    }

    @Test(description="4.3.1 Access Conversion to term currency code XXX for all providers that support according conversion, ifavailable a non-null CurrencyConversion must be provided.")
    @SpecAssertion(id="431-A2", section="4.3.1")
    public void testConversionsAreAvailable() {
        for (String providerName : MonetaryConversions.getProviderNames()) {
            try {
                if (!MonetaryConversions.isConversionAvailable((String)"XXX", (String[])new String[]{providerName})) continue;
                CurrencyConversion conv = MonetaryConversions.getConversion((String)"XXX", (String[])new String[]{providerName});
                AssertJUnit.assertNotNull((String)("CurrencyConversion returned from MonetaryConversions.getConversion(String, String...) should never be null: " + providerName), (Object)conv);
                AssertJUnit.assertTrue((String)("CurrencyConversion is not flagged as available, though it was returned from MonetaryConversions.getConversion(String, String...): " + providerName), (boolean)MonetaryConversions.isConversionAvailable((String)"XXX", (String[])new String[]{providerName}));
            }
            catch (MonetaryException e) {
                AssertJUnit.assertFalse((String)("CurrencyConversion is not flagged as NOT available, though it is not accessible from MonetaryConversions.getConversion(String, String...): " + providerName), (boolean)MonetaryConversions.isConversionAvailable((String)"XXX", (String[])new String[]{providerName}));
            }
        }
    }

    @Test(description="4.3.1 Access Conversion by query to term currency XXX for all providers that support according conversion, ifavailable a non-null CurrencyConversion must be provided.")
    @SpecAssertion(id="431-A2", section="4.3.1")
    public void testConversionsAreAvailableWithQuery() {
        for (String providerName : MonetaryConversions.getProviderNames()) {
            ConversionQuery query = ((ConversionQueryBuilder)ConversionQueryBuilder.of().setTermCurrency("XXX").setProviders(new String[]{providerName})).build();
            try {
                if (!MonetaryConversions.isConversionAvailable((ConversionQuery)query)) continue;
                CurrencyConversion conv = MonetaryConversions.getConversion((ConversionQuery)query);
                AssertJUnit.assertNotNull((String)("CurrencyConversion returned from MonetaryConversions.getConversion(ConversionQuery) must never be null: " + providerName), (Object)conv);
                AssertJUnit.assertTrue((String)("CurrencyConversion is not flagged as available though it was returned from MonetaryConversions.getConversion(ConversionQuery): " + providerName), (boolean)MonetaryConversions.isConversionAvailable((ConversionQuery)query));
            }
            catch (MonetaryException e) {
                AssertJUnit.assertFalse((String)("CurrencyConversion is not flagged as not available, though it was not returned from MonetaryConversions.getConversion(ConversionQuery): " + providerName), (boolean)MonetaryConversions.isConversionAvailable((ConversionQuery)query));
            }
        }
    }

    @Test(description="4.3.1 Test if all ExchangeRateProvider instances returns valid ProviderContext.")
    @SpecAssertion(id="431-A3", section="4.3.1")
    public void testProviderMetadata() {
        for (String providerName : MonetaryConversions.getProviderNames()) {
            ExchangeRateProvider prov = MonetaryConversions.getExchangeRateProvider((String[])new String[]{providerName});
            AssertJUnit.assertNotNull((String)("Provider mot accessible: " + providerName), (Object)prov);
            ProviderContext ctx = prov.getProviderContext();
            AssertJUnit.assertNotNull((String)("ExchangeProvider must return a valid ProviderContext, but returned null: " + providerName), (Object)ctx);
            AssertJUnit.assertEquals((String)("ExchangeProvider's ProviderContext returns invalid name: " + providerName), (String)providerName, (String)ctx.getProvider());
            AssertJUnit.assertNotNull((String)("ExchangeProvider's ProviderContext declares invalid RateTypes to be returned (null): " + providerName), (Object)ctx.getRateTypes());
            AssertJUnit.assertFalse((String)("ExchangeProvider's ProviderContext declares empty RateTypes to be returned: " + providerName), (boolean)ctx.getRateTypes().isEmpty());
        }
    }

    @Test(description="4.3.1 Test if all CurrencyConversion instances returns valid ConversionContext, accessed by currency code.")
    @SpecAssertion(id="431-A3", section="4.3.1")
    public void testProviderMetadata2() {
        for (String providerName : MonetaryConversions.getProviderNames()) {
            if (!MonetaryConversions.isConversionAvailable((String)"XXX", (String[])new String[]{providerName})) continue;
            CurrencyConversion conv = MonetaryConversions.getConversion((String)"XXX", (String[])new String[]{providerName});
            ConversionContext ctx = conv.getConversionContext();
            AssertJUnit.assertNotNull((String)("ExchangeProvider must return a valid ProviderContext, but returned null: " + providerName), (Object)ctx);
            AssertJUnit.assertEquals((String)("ExchangeProvider's ProviderContext returns invalid name: " + providerName), (String)providerName, (String)ctx.getProvider());
            AssertJUnit.assertNotNull((String)("ExchangeProvider's ProviderContext declares invalid RateTypes to be returned (null): " + providerName), (Object)ctx.getRateType());
        }
    }

    @Test(description="4.3.1 Test if all CurrencyConversion instances returns valid ConversionContext, accessed by CurrencyUnit.")
    @SpecAssertion(id="431-A3", section="4.3.1")
    public void testProviderMetadata3() {
        for (String providerName : MonetaryConversions.getProviderNames()) {
            if (!MonetaryConversions.isConversionAvailable((CurrencyUnit)MonetaryCurrencies.getCurrency((String)"XXX", (String[])new String[0]), (String[])new String[]{providerName})) continue;
            CurrencyConversion conv = MonetaryConversions.getConversion((CurrencyUnit)MonetaryCurrencies.getCurrency((String)"XXX", (String[])new String[0]), (String[])new String[]{providerName});
            ConversionContext ctx = conv.getConversionContext();
            AssertJUnit.assertNotNull((String)("ExchangeProvider must return a valid ProviderContext, but returned null: " + providerName), (Object)ctx);
            AssertJUnit.assertEquals((String)("ExchangeProvider's ProviderContext returns invalid name: " + providerName), (String)providerName, (String)ctx.getProvider());
            AssertJUnit.assertNotNull((String)("ExchangeProvider's ProviderContext declares invalid RateTypes to be returned (null): " + providerName), (Object)ctx.getRateType());
        }
    }

    @Test(description="4.3.1 Test if all CurrencyConversion instances returns valid ConversionContext, accessed by ConversionQuery/currency code.")
    @SpecAssertion(id="431-A3", section="4.3.1")
    public void testProviderMetadata2WithContext() {
        for (String providerName : MonetaryConversions.getProviderNames()) {
            ConversionQuery query = ((ConversionQueryBuilder)ConversionQueryBuilder.of().setTermCurrency("XXX").setProviders(new String[]{providerName})).build();
            if (!MonetaryConversions.isConversionAvailable((ConversionQuery)query)) continue;
            CurrencyConversion conv = MonetaryConversions.getConversion((ConversionQuery)query);
            ConversionContext ctx = conv.getConversionContext();
            AssertJUnit.assertNotNull((String)("ExchangeProvider must return a valid ProviderContext, but returned null: " + providerName), (Object)ctx);
            AssertJUnit.assertEquals((String)("ExchangeProvider's ProviderContext returns invalid name: " + providerName), (String)providerName, (String)ctx.getProvider());
            AssertJUnit.assertNotNull((String)("ExchangeProvider's ProviderContext declares invalid RateTypes to be returned (null): " + providerName), (Object)ctx.getRateType());
        }
    }

    @Test(description="4.3.1 Test if all CurrencyConversion instances returns valid ConversionContext, accessed by ConversionQuery/CurrencyUnit.")
    @SpecAssertion(id="431-A3", section="4.3.1")
    public void testProviderMetadata3WithContext() {
        for (String providerName : MonetaryConversions.getProviderNames()) {
            ConversionQuery query = ((ConversionQueryBuilder)ConversionQueryBuilder.of().setTermCurrency(MonetaryCurrencies.getCurrency((String)"XXX", (String[])new String[0])).setProvider(providerName)).build();
            if (!MonetaryConversions.isConversionAvailable((ConversionQuery)query)) continue;
            CurrencyConversion conv = MonetaryConversions.getConversion((ConversionQuery)query);
            ConversionContext ctx = conv.getConversionContext();
            AssertJUnit.assertNotNull((String)("ExchangeProvider must return a valid ProviderContext, but returned null: " + providerName), (Object)ctx);
            AssertJUnit.assertEquals((String)("ExchangeProvider's ProviderContext returns invalid name: " + providerName), (String)providerName, (String)ctx.getProvider());
            AssertJUnit.assertNotNull((String)("ExchangeProvider's ProviderContext declares invalid RateTypes to be returned (null): " + providerName), (Object)ctx.getRateType());
        }
    }

    @Test(description="4.3.1 Access and test the default conversion provider chain.")
    @SpecAssertion(id="431-A4", section="4.3.1")
    public void testDefaultProviderChainIsDefined() {
        ExchangeRateProvider prov = MonetaryConversions.getExchangeRateProvider((String[])new String[0]);
        AssertJUnit.assertNotNull((String)"No default ExchangeRateProvider returned.", (Object)prov);
    }

    @Test(description="4.3.1 Access and test the default conversion provider chain, by accessing a defaultCurrencyConversion for term CurrencyUnit CHF.")
    @SpecAssertion(id="431-A4", section="4.3.1")
    public void testDefaultProviderChainIsDefinedDefault() {
        CurrencyConversion conv = MonetaryConversions.getConversion((CurrencyUnit)MonetaryCurrencies.getCurrency((String)"CHF", (String[])new String[0]), (String[])new String[0]);
        AssertJUnit.assertNotNull((String)"No default CurrencyConversion returned.", (Object)conv);
    }

    @Test(description="4.3.1 Access and test the default conversion provider chain, by accessing a defaultCurrencyConversion for term currency code CHF.")
    @SpecAssertion(id="431-A4", section="4.3.1")
    public void testDefaultProviderChainIsDefinedDefault2() {
        CurrencyConversion conv = MonetaryConversions.getConversion((String)"CHF", (String[])new String[0]);
        AssertJUnit.assertNotNull((String)"No default CurrencyConversion returned.", (Object)conv);
    }

    @Test(description="4.3.1 Access and test the default conversion provider chain, by accessing a defaultCurrencyConversion for ConversionQuery.")
    @SpecAssertion(id="431-A4", section="4.3.1")
    public void testDefaultProviderChainIsDefinedDefaultWithContext() {
        ConversionQuery query = ConversionQueryBuilder.of().setTermCurrency(MonetaryCurrencies.getCurrency((String)"CHF", (String[])new String[0])).build();
        CurrencyConversion conv = MonetaryConversions.getConversion((ConversionQuery)query);
        AssertJUnit.assertNotNull((String)"No default CurrencyConversion returned.", (Object)conv);
    }

    @Test(expectedExceptions={MonetaryException.class}, description="4.3.1 Bad case: Access invalid ExchangeRateProvider, expect MonetaryException thrown, using default provider chain.")
    @SpecAssertion(id="431-A6", section="4.3.1", note="Accessing an invalid provider name, should throw a MonetaryException.")
    public void testUseInvalidProvider() {
        MonetaryConversions.getExchangeRateProvider((String[])new String[]{"Dhdkjdhskljdsudgsdkjgjk sgdsjdg"});
    }

    @Test(expectedExceptions={MonetaryException.class}, description="4.3.1 Bad case: Access invalid ExchangeRateProvider, expect MonetaryException thrown, using explicit provider.")
    @SpecAssertion(id="431-A7", section="4.3.1", note="Accessing an invalid provider name within a name chain, should throw a MonetaryException.")
    public void testUseInvalidProviderWithinChain() {
        MonetaryConversions.getExchangeRateProvider((String[])new String[]{"TestRateProvider", "Dhdkjdhskljdsudgsdkjgjk sgdsjdg"});
    }
}

