/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.tck.tests;

import java.util.Collection;
import javax.money.MonetaryAmount;
import javax.money.MonetaryAmountFactory;
import javax.money.MonetaryAmounts;
import javax.money.MonetaryOperator;
import org.javamoney.tck.TCKTestSetup;
import org.javamoney.tck.tests.internal.TestAmount;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="JSR 354", version="1.0.0")
public class FunctionalExtensionPointsTest {
    @Test(description="4.2.4 Ensures the result of all operators under test is of the same class as the input.")
    @SpecAssertion(section="4.2.4", id="424-A1")
    public void testOperatorReturnTypeEqualsParameter() {
        Collection<MonetaryOperator> operators = TCKTestSetup.getTestConfiguration().getMonetaryOperators4Test();
        Assert.assertNotNull(operators, (String)"No operators (null) to test returned from TestConfiguration.getMonetaryOperators4Test().");
        for (Class type : MonetaryAmounts.getAmountTypes()) {
            if (type.equals(TestAmount.class)) continue;
            MonetaryAmountFactory f = MonetaryAmounts.getAmountFactory((Class)type);
            f.setCurrency("CHF");
            f.setNumber(200.1);
            MonetaryAmount m = f.create();
            for (MonetaryOperator op : operators) {
                MonetaryAmount m2 = m.with(op);
                Assert.assertEquals(m2.getClass(), m.getClass(), (String)("Operator returned type with different type, which is not allowed: " + op.getClass().getName()));
            }
        }
    }
}

