/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activejdbc;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import org.javalite.activejdbc.DBException;
import org.javalite.activejdbc.RowListener;
import org.javalite.common.CaseInsensitiveMap;
import org.javalite.common.Util;

public class RowProcessor {
    private final ResultSet rs;
    private final Statement s;

    protected RowProcessor(ResultSet rs, Statement s) {
        this.rs = rs;
        this.s = s;
    }

    public void with(RowListener listener) {
        try {
            this.processRS(listener);
        }
        catch (SQLException e) {
            throw new DBException(e);
        }
        finally {
            Util.closeQuietly((AutoCloseable)this.rs);
            Util.closeQuietly((AutoCloseable)this.s);
        }
    }

    protected void processRS(RowListener listener) throws SQLException {
        ResultSetMetaData metaData = this.rs.getMetaData();
        String[] labels = new String[metaData.getColumnCount()];
        int i = 0;
        while (i < labels.length) {
            labels[i++] = metaData.getColumnLabel(i);
        }
        while (this.rs.next()) {
            CaseInsensitiveMap row = new CaseInsensitiveMap();
            i = 0;
            while (i < labels.length) {
                row.put(labels[i++], this.rs.getObject(i));
            }
            if (listener.next((Map<String, Object>)row)) continue;
            break;
        }
    }

    public static enum ResultSetConcur {
        READ_ONLY(1007),
        UPDATABLE(1008);

        private int value;

        private ResultSetConcur(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum ResultSetType {
        FORWARD_ONLY(1003),
        SCROLL_INSENSITIVE(1004),
        SCROLL_SENSITIVE(1005);

        private int value;

        private ResultSetType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

