/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activejdbc.logging;

import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.javalite.activejdbc.Configuration;
import org.javalite.activejdbc.Registry;
import org.javalite.activejdbc.logging.LogLevel;
import org.javalite.activejdbc.statistics.QueryExecutionEvent;
import org.javalite.common.JsonHelper;
import org.slf4j.Logger;

public class LogFilter {
    private static Pattern pattern;

    private LogFilter() {
    }

    public static void setLogExpression(String regexp) {
        pattern = Pattern.compile(regexp, 2);
    }

    public static void logQuery(Logger logger, String query, Object[] params, long queryStartTime) {
        long time = System.currentTimeMillis() - queryStartTime;
        LogFilter.collectStatistics(query, time, false);
        LogFilter.log(logger, LogLevel.INFO, () -> LogFilter.getJson(query, params, time));
    }

    public static void logQuery(Logger logger, String query, Object[] params, long queryStartTime, boolean cacheHit) {
        long time = System.currentTimeMillis() - queryStartTime;
        LogFilter.collectStatistics(query, time, cacheHit);
        LogFilter.log(logger, LogLevel.INFO, () -> LogFilter.getJson(query, params, time, cacheHit));
    }

    private static void collectStatistics(String query, long time, boolean cacheHit) {
        if (Registry.instance().getConfiguration().collectStatistics() && !cacheHit) {
            Registry.instance().getStatisticsQueue().enqueue(new QueryExecutionEvent(query, time));
        }
    }

    private static String getJson(String query, Object[] params, long time) {
        return "{\"sql\":\"" + query.replace("\"", "'") + "\",\"params\":[" + LogFilter.getParamsJson(params) + "],\"duration_millis\":" + time + "}";
    }

    private static String getJson(String query, Object[] params, long time, boolean cacheHit) {
        return "{\"sql\":\"" + JsonHelper.sanitize((String)query) + "\",\"params\":[" + LogFilter.getParamsJson(params) + "]" + (String)(!cacheHit ? ",\"duration_millis\":" + time : "") + ",\"cache\":" + (cacheHit ? "\"hit\"" : "\"miss\"") + "}";
    }

    private static String getParamsJson(Object[] params) {
        StringBuilder paramsSB = new StringBuilder("");
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                if (params[i] instanceof Number) {
                    paramsSB.append(JsonHelper.sanitize((String)params[i].toString()));
                } else if (params[i] instanceof byte[]) {
                    paramsSB.append("\"bytes[...]\"");
                } else if (params[i] == null) {
                    paramsSB.append("null");
                } else {
                    paramsSB.append("\"").append(JsonHelper.sanitize((String)params[i].toString())).append("\"");
                }
                if (i == params.length - 1) continue;
                paramsSB.append(",");
            }
        }
        return paramsSB.toString();
    }

    public static void log(Logger logger, LogLevel logLevel, Supplier<String> messageSupplier) {
        if (Configuration.hasActiveLogger()) {
            Configuration.getActiveLogger().log(logger, logLevel, messageSupplier);
        } else {
            switch (logLevel) {
                case DEBUG: {
                    if (!logger.isDebugEnabled()) break;
                    LogFilter.logFiltered(messageSupplier, arg_0 -> ((Logger)logger).debug(arg_0));
                    break;
                }
                case INFO: {
                    if (!logger.isInfoEnabled()) break;
                    LogFilter.logFiltered(messageSupplier, arg_0 -> ((Logger)logger).info(arg_0));
                    break;
                }
                case WARNING: {
                    LogFilter.logFiltered(messageSupplier, arg_0 -> ((Logger)logger).warn(arg_0));
                    break;
                }
                case ERROR: {
                    LogFilter.logFiltered(messageSupplier, arg_0 -> ((Logger)logger).error(arg_0));
                    break;
                }
            }
        }
    }

    private static void logFiltered(Supplier<String> messageSupplier, Consumer<String> messageConsumer) {
        String message = messageSupplier.get();
        if (pattern.matcher(message).matches()) {
            messageConsumer.accept(message);
        }
    }

    public static void log(Logger logger, LogLevel logLevel, String log) {
        if (Configuration.hasActiveLogger()) {
            Configuration.getActiveLogger().log(logger, logLevel, log);
        } else if (LogFilter.matches(logger, logLevel, log)) {
            switch (logLevel) {
                case DEBUG: {
                    logger.debug(log);
                    break;
                }
                case INFO: {
                    logger.info(log);
                    break;
                }
                case WARNING: {
                    logger.warn(log);
                    break;
                }
                case ERROR: {
                    logger.error(log);
                    break;
                }
            }
        }
    }

    public static void log(Logger logger, LogLevel logLevel, String log, Object param) {
        if (Configuration.hasActiveLogger()) {
            Configuration.getActiveLogger().log(logger, logLevel, log, param);
        } else if (LogFilter.matches(logger, logLevel, log)) {
            switch (logLevel) {
                case DEBUG: {
                    logger.debug(log, param);
                    break;
                }
                case INFO: {
                    logger.info(log, param);
                    break;
                }
                case WARNING: {
                    logger.warn(log, param);
                    break;
                }
                case ERROR: {
                    logger.error(log, param);
                    break;
                }
            }
        }
    }

    private static boolean matches(Logger logger, LogLevel logLevel, String log) {
        boolean isEnabled = true;
        switch (logLevel) {
            case DEBUG: {
                isEnabled = logger.isDebugEnabled();
                break;
            }
            case INFO: {
                isEnabled = logger.isInfoEnabled();
                break;
            }
            case WARNING: {
                isEnabled = logger.isWarnEnabled();
                break;
            }
            case ERROR: {
                isEnabled = logger.isErrorEnabled();
                break;
            }
        }
        return isEnabled && pattern.matcher(log).matches();
    }

    public static void log(Logger logger, LogLevel logLevel, String log, Object param1, Object param2) {
        if (Configuration.hasActiveLogger()) {
            Configuration.getActiveLogger().log(logger, logLevel, log, param1, param2);
        } else if (LogFilter.matches(logger, logLevel, log)) {
            switch (logLevel) {
                case DEBUG: {
                    logger.debug(log, param1, param2);
                    break;
                }
                case INFO: {
                    logger.info(log, param1, param2);
                    break;
                }
                case WARNING: {
                    logger.warn(log, param1, param2);
                    break;
                }
                case ERROR: {
                    logger.error(log, param1, param2);
                    break;
                }
            }
        }
    }

    public static void log(Logger logger, LogLevel logLevel, String log, Object ... params) {
        if (Configuration.hasActiveLogger()) {
            Configuration.getActiveLogger().log(logger, logLevel, log, params);
        } else if (LogFilter.matches(logger, logLevel, log)) {
            switch (logLevel) {
                case DEBUG: {
                    logger.debug(log, params);
                    break;
                }
                case INFO: {
                    logger.info(log, params);
                    break;
                }
                case WARNING: {
                    logger.warn(log, params);
                    break;
                }
                case ERROR: {
                    logger.error(log, params);
                    break;
                }
            }
        }
    }

    static {
        String logFlag = System.getProperty("activejdbc.log");
        if (logFlag != null && logFlag.equals("")) {
            LogFilter.setLogExpression(".*");
        } else if (logFlag != null) {
            LogFilter.setLogExpression(logFlag);
        } else {
            LogFilter.setLogExpression("a{10000000}");
        }
    }
}

