/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activejdbc.dialects;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.regex.Pattern;
import org.javalite.activejdbc.MetaModel;
import org.javalite.activejdbc.ModelDelegate;
import org.javalite.activejdbc.associations.Many2ManyAssociation;
import org.javalite.activejdbc.dialects.Dialect;
import org.javalite.common.CaseInsensitiveMap;
import org.javalite.common.Convert;
import org.javalite.common.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDialect
implements Dialect {
    private static Logger LOGGER = LoggerFactory.getLogger(DefaultDialect.class);
    protected static final Pattern ORDER_BY_PATTERN = Pattern.compile("^\\s*ORDER\\s+BY", 10);
    protected static final Pattern GROUP_BY_PATTERN = Pattern.compile("^\\s*GROUP\\s+BY", 10);

    @Override
    public String selectStar(String table) {
        return "SELECT * FROM " + table;
    }

    @Override
    public String selectStar(String table, String where) {
        return where != null ? "SELECT * FROM " + table + " WHERE " + where : this.selectStar(table);
    }

    @Override
    public String selectStarParametrized(String table, String ... parameters) {
        StringBuilder sql = new StringBuilder().append("SELECT * FROM ").append(table).append(" WHERE ");
        Util.join((StringBuilder)sql, (Object[])parameters, (String)" = ? AND ");
        sql.append(" = ?");
        return sql.toString();
    }

    protected void appendEmptyRow(MetaModel metaModel, StringBuilder query) {
        query.append("DEFAULT VALUES");
    }

    protected void appendQuestions(StringBuilder query, int count) {
        Util.joinAndRepeat((StringBuilder)query, (String)"?", (String)", ", (int)count);
    }

    protected void appendOrderBy(StringBuilder query, List<String> orderBys) {
        if (!orderBys.isEmpty()) {
            query.append(" ORDER BY ");
            Util.join((StringBuilder)query, orderBys, (String)", ");
        }
    }

    protected void appendSubQuery(StringBuilder queryBuilder, String subQuery) {
        if (!Util.blank((Object)subQuery)) {
            if (!GROUP_BY_PATTERN.matcher(subQuery).find() && !ORDER_BY_PATTERN.matcher(subQuery).find()) {
                queryBuilder.append(" WHERE");
            }
            queryBuilder.append(' ').append(subQuery);
        }
    }

    protected void appendSelect(StringBuilder queryBuilder, String tableName, String[] columns, String tableAlias, String subQuery, List<String> orderBys) {
        if (tableName == null) {
            queryBuilder.append(subQuery);
        } else {
            if (tableAlias == null) {
                String cols = columns == null ? "*" : Util.join((String[])columns, (String)",");
                queryBuilder.append("SELECT ").append(cols).append(" FROM ").append(tableName);
            } else {
                queryBuilder.append("SELECT ").append(tableAlias).append(".* FROM ").append(tableName).append(' ').append(tableAlias);
            }
            this.appendSubQuery(queryBuilder, subQuery);
        }
        this.appendOrderBy(queryBuilder, orderBys);
    }

    @Override
    public String formSelect(String tableName, String[] columns, String subQuery, List<String> orderBys, long limit, long offset) {
        LOGGER.error("ERROR!!!! Limit and Offset are not supported by DefaultDialect");
        StringBuilder queryBuilder = new StringBuilder();
        this.appendSelect(queryBuilder, tableName, columns, null, subQuery, orderBys);
        return queryBuilder.toString();
    }

    @Override
    public Object overrideDriverTypeConversion(MetaModel mm, String attributeName, Object value) {
        return value;
    }

    @Override
    public String selectCount(String from) {
        return "SELECT COUNT(*) FROM " + from;
    }

    @Override
    public String selectCount(String table, String where) {
        return "SELECT COUNT(*) FROM " + table + " WHERE " + where;
    }

    @Override
    public String selectExists(MetaModel metaModel) {
        return "SELECT " + metaModel.getIdName() + " FROM " + metaModel.getTableName() + " WHERE " + metaModel.getIdName() + " = ?";
    }

    @Override
    public String selectManyToManyAssociation(Many2ManyAssociation association, String sourceFkColumnName, int questionsCount) {
        String targetTable = ModelDelegate.metaModelOf(association.getTargetClass()).getTableName();
        StringBuilder query = new StringBuilder().append("SELECT ").append(targetTable).append(".*, t.").append(association.getSourceFkName()).append(" AS ").append(sourceFkColumnName).append(" FROM ").append(targetTable).append(" INNER JOIN ").append(association.getJoin()).append(" t ON ").append(targetTable).append('.').append(association.getTargetPk()).append(" = t.").append(association.getTargetFkName()).append(" WHERE t.").append(association.getSourceFkName()).append(" IN (");
        this.appendQuestions(query, questionsCount);
        query.append(')');
        return query.toString();
    }

    @Override
    public String insertManyToManyAssociation(Many2ManyAssociation association) {
        return "INSERT INTO " + association.getJoin() + " (" + association.getSourceFkName() + ", " + association.getTargetFkName() + ") VALUES (?, ?)";
    }

    @Override
    public String insertParametrized(MetaModel metaModel, List<String> columns, boolean containsId) {
        StringBuilder query = new StringBuilder().append("INSERT INTO ").append(metaModel.getTableName()).append(' ');
        if (columns.isEmpty()) {
            this.appendEmptyRow(metaModel, query);
        } else {
            boolean addIdGeneratorCode = !containsId && metaModel.getIdGeneratorCode() != null;
            query.append('(');
            if (addIdGeneratorCode) {
                query.append(metaModel.getIdName()).append(", ");
            }
            Util.join((StringBuilder)query, columns, (String)", ");
            query.append(") VALUES (");
            if (addIdGeneratorCode) {
                query.append(metaModel.getIdGeneratorCode()).append(", ");
            }
            this.appendQuestions(query, columns.size());
            query.append(')');
        }
        return query.toString();
    }

    @Override
    public String deleteManyToManyAssociation(Many2ManyAssociation association) {
        return "DELETE FROM " + association.getJoin() + " WHERE " + association.getSourceFkName() + " = ? AND " + association.getTargetFkName() + " = ?";
    }

    protected void appendValue(StringBuilder query, Object value, String ... replacements) {
        if (value == null) {
            query.append("NULL");
        } else if (value instanceof Number) {
            query.append(value);
        } else if (value instanceof Date) {
            this.appendDate(query, (Date)value);
        } else if (value instanceof Time) {
            this.appendTime(query, (Time)value);
        } else if (value instanceof Timestamp) {
            this.appendTimestamp(query, (Timestamp)value);
        } else {
            query.append('\'').append(this.replace(value, replacements)).append('\'');
        }
    }

    protected String replace(Object valueObject, String ... replacements) {
        String value = Convert.toString((Object)valueObject);
        if (replacements.length % 2 != 0) {
            throw new IllegalArgumentException("Number of elements in 'replacements' array is not even");
        }
        if (replacements.length > 0) {
            String v = "";
            for (int i = 0; i < replacements.length - 1; i += 2) {
                v = value.replaceAll(replacements[i], replacements[i + 1]);
            }
            return v;
        }
        return value;
    }

    protected void appendDate(StringBuilder query, Date value) {
        query.append("DATE ").append('\'').append(value.toString()).append('\'');
    }

    protected void appendTime(StringBuilder query, Time value) {
        query.append("TIME ").append('\'').append(value.toString()).append('\'');
    }

    protected void appendTimestamp(StringBuilder query, Timestamp value) {
        query.append("TIMESTAMP ").append('\'').append(value.toString()).append('\'');
    }

    @Override
    public String insert(MetaModel metaModel, Map<String, Object> attributes, String ... replacements) {
        StringBuilder query = new StringBuilder().append("INSERT INTO ").append(metaModel.getTableName()).append(' ');
        if (attributes.isEmpty()) {
            this.appendEmptyRow(metaModel, query);
        } else {
            boolean addIdGeneratorCode = metaModel.getIdGeneratorCode() != null && attributes.get(metaModel.getIdName()) == null;
            query.append('(');
            if (addIdGeneratorCode) {
                query.append(metaModel.getIdName()).append(", ");
            }
            Util.join((StringBuilder)query, attributes.keySet(), (String)", ");
            query.append(") VALUES (");
            if (addIdGeneratorCode) {
                query.append(metaModel.getIdGeneratorCode()).append(", ");
            }
            Iterator<Object> it = attributes.values().iterator();
            this.appendValue(query, it.next(), new String[0]);
            while (it.hasNext()) {
                query.append(", ");
                this.appendValue(query, it.next(), replacements);
            }
            query.append(')');
        }
        return query.toString();
    }

    @Override
    public String update(MetaModel metaModel, Map<String, Object> attributes, String ... replacements) {
        if (attributes.isEmpty()) {
            throw new NoSuchElementException("No attributes set, can't create an update statement.");
        }
        StringBuilder query = new StringBuilder().append("UPDATE ").append(metaModel.getTableName()).append(" SET ");
        String idName = metaModel.getIdName();
        CaseInsensitiveMap attributesWithoutId = new CaseInsensitiveMap(attributes);
        attributesWithoutId.remove(idName);
        Iterator it = attributesWithoutId.entrySet().iterator();
        while (true) {
            Map.Entry attribute = it.next();
            query.append((String)attribute.getKey()).append(" = ");
            this.appendValue(query, attribute.getValue(), replacements);
            if (!it.hasNext()) break;
            query.append(", ");
        }
        if (metaModel.getCompositeKeys() == null) {
            query.append(" WHERE ").append(idName).append(" = ").append(attributes.get(idName));
        } else {
            String[] compositeKeys = metaModel.getCompositeKeys();
            for (int i = 0; i < compositeKeys.length; ++i) {
                query.append(i == 0 ? " WHERE " : " AND ").append(compositeKeys[i]).append(" = ");
                this.appendValue(query, attributes.get(compositeKeys[i]), new String[0]);
            }
        }
        return query.toString();
    }
}

