/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activejdbc.cache;

import java.util.Arrays;
import org.javalite.activejdbc.InitException;
import org.javalite.activejdbc.MetaModel;
import org.javalite.activejdbc.Registry;
import org.javalite.activejdbc.cache.CacheEvent;
import org.javalite.activejdbc.cache.CacheManager;
import org.javalite.activejdbc.cache.NopeCacheManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum QueryCache {
    INSTANCE;

    private static final Logger LOGGER;
    private boolean enabled = false;
    private final CacheManager cacheManager;

    private QueryCache() {
        String cacheManagerClass = Registry.instance().getConfiguration().getCacheManager();
        if (cacheManagerClass != null) {
            try {
                Class<?> cmc = Class.forName(cacheManagerClass);
                this.cacheManager = (CacheManager)cmc.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this.enabled = true;
            }
            catch (InitException e) {
                throw e;
            }
            catch (Exception e) {
                throw new InitException("Failed to initialize a CacheManager. Please, ensure that the property 'cache.manager' points to correct class which extends '" + CacheManager.class.getName() + "' and provides a default constructor.", e);
            }
        } else {
            this.cacheManager = new NopeCacheManager();
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public static QueryCache instance() {
        return INSTANCE;
    }

    public void addItem(String tableName, String query, Object[] params, Object cache) {
        if (this.enabled) {
            this.cacheManager.addCache(tableName, this.getKey(tableName, query, params), cache);
        }
    }

    public Object getItem(String tableName, String query, Object[] params) {
        if (this.enabled) {
            String key = this.getKey(tableName, query, params);
            return this.cacheManager.getCache(tableName, key);
        }
        return null;
    }

    private String getKey(String tableName, String query, Object[] params) {
        return tableName + query + (params == null ? null : Arrays.asList(params).toString());
    }

    public void purgeTableCache(MetaModel metaModel) {
        if (this.enabled && metaModel.cached()) {
            this.cacheManager.flush(new CacheEvent(metaModel.getTableName(), ((Object)((Object)this)).getClass().getName()));
        }
    }

    public void purgeTableCache(String tableName) {
        MetaModel mm;
        if (this.enabled && (mm = Registry.instance().getMetaModel(tableName)) != null && mm.cached()) {
            this.cacheManager.flush(new CacheEvent(mm.getTableName(), ((Object)((Object)this)).getClass().getName()));
        }
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    static {
        LOGGER = LoggerFactory.getLogger(QueryCache.class);
    }
}

