/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activejdbc.associations;

import java.util.Map;
import org.javalite.activejdbc.Model;
import org.javalite.activejdbc.associations.Association;

public class OneToManyPolymorphicAssociation
extends Association {
    public static final String TYPE = "type";
    private String typeLabel;

    public OneToManyPolymorphicAssociation(Map<String, Object> map) throws ClassNotFoundException {
        super(map);
        this.typeLabel = (String)map.get(TYPE);
    }

    public OneToManyPolymorphicAssociation(Class<? extends Model> source, Class<? extends Model> target, String typeLabel) {
        super(source, target);
        this.typeLabel = typeLabel;
    }

    public String getTypeLabel() {
        return this.typeLabel;
    }

    public String toString() {
        return this.getSourceClass().getSimpleName() + "  ----------<  " + this.getTargetClass().getSimpleName() + ", type: has-many-polymorphic";
    }

    public boolean equals(Object other) {
        if (other == null || !other.getClass().equals(this.getClass())) {
            return false;
        }
        OneToManyPolymorphicAssociation otherAss = (OneToManyPolymorphicAssociation)other;
        return otherAss.typeLabel.equals(this.typeLabel) && otherAss.getSourceClass().equals(this.getSourceClass()) && otherAss.getTargetClass().equals(this.getTargetClass());
    }

    @Override
    public Map<String, Object> toMap() {
        Map<String, Object> map = super.toMap();
        map.put(TYPE, this.typeLabel);
        return map;
    }
}

