/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activejdbc;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.javalite.activejdbc.InitException;
import org.javalite.activejdbc.MetaModel;
import org.javalite.activejdbc.Model;
import org.javalite.activejdbc.Registry;
import org.javalite.activejdbc.logging.LogFilter;
import org.javalite.activejdbc.logging.LogLevel;
import org.javalite.common.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelFinder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModelFinder.class);
    private static Map<String, Set<String>> modelMap;

    private static synchronized Map<String, Set<String>> getModelMap() {
        if (modelMap == null) {
            try {
                modelMap = new HashMap<String, Set<String>>();
                Enumeration<URL> urls = ((Object)((Object)Registry.instance())).getClass().getClassLoader().getResources(Registry.instance().getModelFile());
                while (urls.hasMoreElements()) {
                    String[] lines;
                    URL url = urls.nextElement();
                    LogFilter.log(LOGGER, LogLevel.INFO, "Loading models from: {}", (Object)url.toExternalForm());
                    String modelsFile = Util.read((InputStream)url.openStream());
                    for (String line : lines = Util.split((String)modelsFile, (String)System.getProperty("line.separator"))) {
                        String[] parts = Util.split((String)line, (char)':');
                        String modelName = parts[0];
                        String dbName = parts[1];
                        Set modelNames = modelMap.computeIfAbsent(dbName, k -> new HashSet());
                        if (modelNames.add(modelName)) continue;
                        throw new InitException(String.format("Model '{}' already exists for database '{}'", modelName, dbName));
                    }
                }
            }
            catch (IOException e) {
                throw new InitException(e);
            }
        }
        return modelMap;
    }

    protected static Set<Class<? extends Model>> getModelsForDb(String dbName) throws ClassNotFoundException {
        Set<String> modelClassNames = ModelFinder.getModelMap().get(dbName);
        HashSet<Class<? extends Model>> classSet = new HashSet<Class<? extends Model>>();
        if (modelClassNames != null) {
            for (String className : modelClassNames) {
                Class<?> modelClass = Class.forName(className);
                if (!modelClass.equals(Model.class) && Model.class.isAssignableFrom(modelClass)) {
                    String realDbName = MetaModel.getDbName(modelClass);
                    if (realDbName.equals(dbName)) {
                        classSet.add(modelClass);
                        continue;
                    }
                    throw new InitException("invalid database association for the " + className + ". Real database name: " + realDbName);
                }
                throw new InitException("invalid class in the models list: " + className);
            }
        }
        if (classSet.isEmpty()) {
            throw new InitException("you are trying to work with models, but no models are found. Maybe you have no models in project, or you did not instrument the models. It is expected that you have a file activejdbc_models.properties on classpath");
        }
        return classSet;
    }
}

