/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activejdbc.statistics;

public class QueryStats {
    private final String query;
    private long total;
    private long avg;
    private long min;
    private long max;
    private long count;

    public QueryStats(String query) {
        this.query = query;
    }

    public void addQueryTime(long time) {
        if (time < this.min || this.min == 0L) {
            this.min = time;
        }
        if (time > this.max || this.max == 0L) {
            this.max = time;
        }
        this.avg = Math.round((double)this.avg + (double)(time - this.avg) / (double)(++this.count));
        this.total += time;
    }

    public long getAvg() {
        return this.avg;
    }

    public long getMin() {
        return this.min;
    }

    public long getMax() {
        return this.max;
    }

    public long getCount() {
        return this.count;
    }

    public long getTotal() {
        return this.total;
    }

    public String getQuery() {
        return this.query;
    }

    public String toString() {
        return "QueryStats{query='" + this.query + '\'' + ", min=" + this.min + ", max=" + this.max + ", count=" + this.count + ", total=" + this.total + ", avg=" + this.avg + '}';
    }
}

