/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activejdbc.connection_config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.javalite.activejdbc.Configuration;
import org.javalite.activejdbc.InitException;
import org.javalite.activejdbc.connection_config.ConnectionJdbcSpec;
import org.javalite.activejdbc.connection_config.ConnectionJndiSpec;
import org.javalite.activejdbc.connection_config.ConnectionSpecWrapper;
import org.javalite.common.Util;

public class DbConfiguration {
    private static HashMap<String, List<ConnectionSpecWrapper>> connectionWrappers = new HashMap();

    public static void addConnectionWrapper(ConnectionSpecWrapper connectionWrapper, boolean override) {
        String connectionWrapperEnv = connectionWrapper.getEnvironment();
        List<ConnectionSpecWrapper> envConnectionWrappers = connectionWrappers.get(connectionWrapperEnv);
        if (envConnectionWrappers == null || override) {
            envConnectionWrappers = new ArrayList<ConnectionSpecWrapper>();
            connectionWrappers.put(connectionWrapperEnv, envConnectionWrappers);
        }
        envConnectionWrappers.add(connectionWrapper);
    }

    public static List<ConnectionSpecWrapper> getConnectionSpecWrappers() {
        return DbConfiguration.getConnectionSpecWrappers(Configuration.getEnv());
    }

    public static List<ConnectionSpecWrapper> getConnectionSpecWrappers(String env) {
        return connectionWrappers.get(env) == null ? new ArrayList() : connectionWrappers.get(env);
    }

    public static void clearConnectionWrappers() {
        DbConfiguration.clearConnectionWrappers(Configuration.getEnv());
    }

    public static void resetConnectionWrappers() {
        connectionWrappers = new HashMap();
    }

    protected static void clearConnectionWrappers(String env) {
        if (connectionWrappers.get(env) != null) {
            connectionWrappers.get(env).clear();
        }
    }

    public static void loadConfiguration(String file) {
        try {
            Properties props = Util.readProperties((String)file);
            Set<String> environments = DbConfiguration.getEnvironments(props);
            for (String env : environments) {
                String jndiName = env + "." + "jndi";
                if (props.containsKey(jndiName)) {
                    DbConfiguration.createJndiWrapper(env, props.getProperty(jndiName));
                    continue;
                }
                String driver = props.getProperty(env + ".driver");
                String userName = props.getProperty(env + ".username");
                String password = props.getProperty(env + ".password");
                String url = props.getProperty(env + ".url");
                DbConfiguration.checkProps(driver, userName, password, url, env);
                DbConfiguration.createJdbcWrapper(env, driver, url, userName, password);
            }
        }
        catch (InitException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InitException(e);
        }
    }

    private static void checkProps(String driver, String userName, String password, String url, String env) {
        if (driver == null || userName == null || password == null || url == null) {
            throw new InitException("Four JDBC properties are expected: driver, username, password, url for environment: " + env);
        }
    }

    private static void createJdbcWrapper(String env, String driver, String url, String userName, String password) {
        ConnectionSpecWrapper wrapper = new ConnectionSpecWrapper();
        if (env.equals("test")) {
            wrapper.setEnvironment("development");
            wrapper.setTesting(true);
        } else if (env.endsWith(".test")) {
            wrapper.setEnvironment(env.split("\\.")[0]);
            wrapper.setTesting(true);
        } else {
            wrapper.setEnvironment(env);
        }
        ConnectionJdbcSpec connectionSpec = new ConnectionJdbcSpec(driver, url, userName, password);
        wrapper.setConnectionSpec(connectionSpec);
        DbConfiguration.addConnectionWrapper(wrapper, false);
    }

    private static void createJndiWrapper(String env, String jndiName) {
        ConnectionSpecWrapper wrapper = new ConnectionSpecWrapper();
        wrapper.setEnvironment(env);
        ConnectionJndiSpec connectionSpec = new ConnectionJndiSpec(jndiName);
        wrapper.setConnectionSpec(connectionSpec);
        DbConfiguration.addConnectionWrapper(wrapper, false);
    }

    private static Set<String> getEnvironments(Properties props) {
        HashSet<String> environments = new HashSet<String>();
        for (String prop : props.stringPropertyNames()) {
            String[] parts = prop.split("\\.");
            if (parts.length == 2) {
                environments.add(parts[0]);
                continue;
            }
            if (parts.length == 3 && parts[1].equals("test")) {
                environments.add(parts[0] + ".test");
                continue;
            }
            throw new InitException("Incorrect property: " + prop);
        }
        return environments;
    }

    public List<ConnectionSpecWrapper> getTestConnectionWrappers() {
        List<ConnectionSpecWrapper> allConnections = DbConfiguration.getConnectionSpecWrappers();
        LinkedList<ConnectionSpecWrapper> result = new LinkedList<ConnectionSpecWrapper>();
        for (ConnectionSpecWrapper connectionWrapper : allConnections) {
            if (!connectionWrapper.isTesting()) continue;
            result.add(connectionWrapper);
        }
        return result;
    }
}

