/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activejdbc.cache;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.javalite.activejdbc.InitException;
import org.javalite.activejdbc.cache.CacheEvent;
import org.javalite.activejdbc.cache.CacheException;
import org.javalite.activejdbc.cache.CacheManager;
import org.javalite.app_config.AppConfig;
import org.javalite.common.Convert;
import org.javalite.common.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

public class RedisCacheManager
extends CacheManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisCacheManager.class);
    private JedisPool jedisPool;

    public RedisCacheManager() {
        try {
            String host = AppConfig.p((String)"redis.cache.manager.host");
            String port = AppConfig.p((String)"redis.cache.manager.port");
            this.jedisPool = Util.blank((Object)host) || Util.blank((Object)port) ? new JedisPool() : new JedisPool(host, Convert.toInteger((Object)port).intValue());
        }
        catch (Exception e) {
            throw new InitException("Failed to configure connection to Redis server", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object getCache(String group, String key) {
        try (Jedis jedis = this.jedisPool.getResource();){
            byte[] bytes = jedis.hget(group.getBytes(), key.getBytes());
            if (bytes == null) {
                Object var6_8 = null;
                return var6_8;
            }
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes));
            Object object = in.readObject();
            return object;
        }
        catch (Exception e) {
            throw new CacheException("Failed to read object from Redis", e);
        }
    }

    @Override
    public void addCache(String group, String key, Object cache) {
        try (Jedis jedis = this.jedisPool.getResource();){
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            ObjectOutputStream objectOutput = new ObjectOutputStream(bout);
            objectOutput.writeObject(cache);
            objectOutput.close();
            byte[] bytes = bout.toByteArray();
            jedis.hset(group.getBytes(), key.getBytes(), bytes);
        }
        catch (Exception e) {
            LOGGER.error("Failed to add object to cache with group: " + group + " and key: " + key, (Throwable)e);
        }
    }

    @Override
    public void doFlush(CacheEvent event) {
        if (event.getType().equals((Object)CacheEvent.CacheEventType.ALL)) {
            throw new UnsupportedOperationException("Flushing all caches not supported");
        }
        if (event.getType().equals((Object)CacheEvent.CacheEventType.GROUP)) {
            try (Jedis jedis = this.jedisPool.getResource();){
                jedis.del(event.getGroup().getBytes());
            }
        }
    }

    @Override
    public Object getImplementation() {
        return this.jedisPool;
    }
}

