/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activejdbc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.javalite.activejdbc.CaseInsensitiveMap;
import org.javalite.activejdbc.InitException;
import org.javalite.activejdbc.LogFilter;
import org.javalite.activejdbc.MetaModel;
import org.javalite.activejdbc.cache.CacheManager;
import org.javalite.activejdbc.cache.NopeCacheManager;
import org.javalite.activejdbc.connection_config.ConnectionJdbcSpec;
import org.javalite.activejdbc.connection_config.ConnectionJndiSpec;
import org.javalite.activejdbc.connection_config.ConnectionSpec;
import org.javalite.activejdbc.dialects.DefaultDialect;
import org.javalite.activejdbc.dialects.Dialect;
import org.javalite.activejdbc.dialects.H2Dialect;
import org.javalite.activejdbc.dialects.MSSQLDialect;
import org.javalite.activejdbc.dialects.MySQLDialect;
import org.javalite.activejdbc.dialects.OracleDialect;
import org.javalite.activejdbc.dialects.PostgreSQLDialect;
import org.javalite.activejdbc.dialects.SQLiteDialect;
import org.javalite.common.Convert;
import org.javalite.common.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configuration {
    private Map<String, List<String>> modelsMap = new HashMap<String, List<String>>();
    private Properties properties = new Properties();
    private static CacheManager cacheManager;
    private static final Logger LOGGER;
    private static String ENV;
    private Map<String, Dialect> dialects = new CaseInsensitiveMap<Dialect>();
    private Map<String, ConnectionSpec> connectionSpecMap = new HashMap<String, ConnectionSpec>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Configuration() {
        this.loadConnectionsSpecs();
        try {
            Enumeration<URL> resources = this.getClass().getClassLoader().getResources("activejdbc_models.properties");
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                LogFilter.log(LOGGER, "Load models from: {}", (Object)url.toExternalForm());
                InputStream inputStream = null;
                InputStreamReader isreader = null;
                BufferedReader reader = null;
                try {
                    String line;
                    inputStream = url.openStream();
                    isreader = new InputStreamReader(inputStream);
                    reader = new BufferedReader(isreader);
                    while ((line = reader.readLine()) != null) {
                        String[] parts = Util.split((String)line, (char)':');
                        String modelName = parts[0];
                        String dbName = parts[1];
                        List<String> modelNames = this.modelsMap.get(dbName);
                        if (modelNames == null) {
                            modelNames = new ArrayList<String>();
                            this.modelsMap.put(dbName, modelNames);
                        }
                        modelNames.add(modelName);
                    }
                }
                catch (Throwable throwable) {
                    Util.closeQuietly(reader);
                    Util.closeQuietly(isreader);
                    Util.closeQuietly((AutoCloseable)inputStream);
                    throw throwable;
                }
                Util.closeQuietly((AutoCloseable)reader);
                Util.closeQuietly((AutoCloseable)isreader);
                Util.closeQuietly((AutoCloseable)inputStream);
            }
        }
        catch (IOException e) {
            throw new InitException(e);
        }
        if (this.modelsMap.isEmpty()) {
            LogFilter.log(LOGGER, "ActiveJDBC Warning: Cannot locate any models, assuming project without models.");
            return;
        }
        try {
            InputStream in = this.getClass().getResourceAsStream("/activejdbc.properties");
            if (in != null) {
                this.properties.load(in);
            }
        }
        catch (IOException e) {
            throw new InitException(e);
        }
        String cacheManagerClass = this.properties.getProperty("cache.manager");
        if (cacheManagerClass == null) {
            cacheManager = new NopeCacheManager();
            return;
        }
        try {
            Class<?> cmc = Class.forName(cacheManagerClass);
            cacheManager = (CacheManager)cmc.newInstance();
            return;
        }
        catch (InitException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InitException("failed to initialize a CacheManager. Please, ensure that the property 'cache.manager' points to correct class which extends '" + CacheManager.class.getName() + "' and provides a default constructor.", e);
        }
    }

    private void loadConnectionsSpecs() {
        try {
            String propertyFileName = this.properties == null ? "database.properties" : this.properties.getProperty("env.connections.file", "database.properties");
            Properties connectionProps = this.readPropertyFile(propertyFileName);
            for (String env : this.getEnvironments(connectionProps)) {
                String jndiName = env + "." + "jndi";
                if (connectionProps.containsKey(jndiName)) {
                    this.connectionSpecMap.put(env, new ConnectionJndiSpec(connectionProps.getProperty(jndiName)));
                    continue;
                }
                String driver = connectionProps.getProperty(env + ".driver");
                String userName = connectionProps.getProperty(env + ".username");
                String password = connectionProps.getProperty(env + ".password");
                String url = connectionProps.getProperty(env + ".url");
                if (driver == null || userName == null || password == null || url == null) {
                    throw new InitException("Four JDBC properties are expected: driver, username, password, url for environment: " + env);
                }
                this.connectionSpecMap.put(env, new ConnectionJdbcSpec(driver, url, userName, password));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.overrideFromEnvironmentVariables();
        this.overrideFromSystemProperties();
    }

    private void overrideFromEnvironmentVariables() {
        String jndi;
        String url = System.getenv("ACTIVEJDBC.URL");
        String user = System.getenv("ACTIVEJDBC.USER");
        String password = System.getenv("ACTIVEJDBC.PASSWORD");
        String driver = System.getenv("ACTIVEJDBC.DRIVER");
        if (!(Util.blank((Object)url) || Util.blank((Object)user) || Util.blank((Object)password) || Util.blank((Object)driver))) {
            this.connectionSpecMap.put(this.getEnvironment(), new ConnectionJdbcSpec(driver, url, user, password));
        }
        if (!Util.blank((Object)(jndi = System.getenv("ACTIVEJDBC.JNDI")))) {
            this.connectionSpecMap.put(this.getEnvironment(), new ConnectionJndiSpec(jndi));
        }
    }

    private void overrideFromSystemProperties() {
        String jndi;
        String url = System.getProperty("activejdbc.url");
        String user = System.getProperty("activejdbc.user");
        String password = System.getProperty("activejdbc.password");
        String driver = System.getProperty("activejdbc.driver");
        if (!(Util.blank((Object)url) || Util.blank((Object)user) || Util.blank((Object)password) || Util.blank((Object)driver))) {
            this.connectionSpecMap.put(this.getEnvironment(), new ConnectionJdbcSpec(driver, url, user, password));
        }
        if (!Util.blank((Object)(jndi = System.getProperty("activejdbc.jndi")))) {
            this.connectionSpecMap.put(this.getEnvironment(), new ConnectionJndiSpec(jndi));
        }
    }

    public ConnectionSpec getConnectionSpec(String environment) {
        return this.connectionSpecMap.get(environment);
    }

    public ConnectionSpec getCurrentConnectionSpec() {
        return this.getConnectionSpec(this.getEnvironment());
    }

    public String getEnvironment() {
        String env = "development";
        if (!Util.blank((Object)System.getenv("ACTIVE_ENV"))) {
            env = System.getenv("ACTIVE_ENV");
        }
        if (!Util.blank((Object)System.getProperty("active_env"))) {
            env = System.getProperty("active_env");
        }
        return env;
    }

    private Set<String> getEnvironments(Properties props) {
        HashSet<String> environments = new HashSet<String>();
        for (Object k : props.keySet()) {
            String environment = k.toString().split("\\.")[0];
            environments.add(environment);
        }
        return new TreeSet<String>(environments);
    }

    private Properties readPropertyFile(String file) throws IOException {
        String fileName = file.startsWith("/") ? file : "/" + file;
        return Util.readProperties((String)fileName);
    }

    List<String> getModelNames(String dbName) throws IOException {
        return this.modelsMap.get(dbName);
    }

    public boolean collectStatistics() {
        return Convert.toBoolean((Object)this.properties.getProperty("collectStatistics", "false"));
    }

    public boolean collectStatisticsOnHold() {
        return Convert.toBoolean((Object)this.properties.getProperty("collectStatisticsOnHold", "false"));
    }

    public boolean cacheEnabled() {
        return cacheManager != null;
    }

    public Dialect getDialect(MetaModel mm) {
        return this.getDialect(mm.getDbType());
    }

    public Dialect getDialect(String dbType) {
        Dialect dialect = this.dialects.get(dbType);
        if (dialect == null) {
            dialect = dbType.equalsIgnoreCase("Oracle") ? new OracleDialect() : (dbType.equalsIgnoreCase("MySQL") ? new MySQLDialect() : (dbType.equalsIgnoreCase("PostgreSQL") ? new PostgreSQLDialect() : (dbType.equalsIgnoreCase("h2") ? new H2Dialect() : (dbType.equalsIgnoreCase("Microsoft SQL Server") ? new MSSQLDialect() : (dbType.equalsIgnoreCase("SQLite") ? new SQLiteDialect() : new DefaultDialect())))));
            this.dialects.put(dbType, dialect);
        }
        return dialect;
    }

    public CacheManager getCacheManager() {
        return cacheManager;
    }

    public static String getEnv() {
        if (ENV == null) {
            if (!Util.blank((Object)System.getenv("ACTIVE_ENV"))) {
                ENV = System.getenv("ACTIVE_ENV");
            }
            if (!Util.blank((Object)System.getProperty("ACTIVE_ENV"))) {
                ENV = System.getProperty("ACTIVE_ENV");
            }
            if (!Util.blank((Object)System.getProperty("active_env"))) {
                ENV = System.getProperty("active_env");
            }
            if (Util.blank((Object)ENV)) {
                ENV = "development";
                LOGGER.warn("Environment variable ACTIVE_ENV not provided, defaulting to '" + ENV + "'");
            }
        }
        return ENV;
    }

    public static void setEnv(String env) {
        ENV = env;
    }

    static {
        LOGGER = LoggerFactory.getLogger(Configuration.class);
    }
}

