/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache.logging;

import java.io.Closeable;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;
import javax.cache.CacheException;
import javax.cache.configuration.Configuration;
import javax.cache.processor.EntryProcessorException;
import org.infinispan.jcache.logging.Log;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;

public class Log_$logger
extends DelegatingBasicLogger
implements Log,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public Log_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String cacheManagerNotClosed$str() {
        return "ISPN021001: Allocation stack trace:";
    }

    @Override
    public final Log.LeakDescription cacheManagerNotClosed() {
        Log.LeakDescription result = new Log.LeakDescription(String.format(this.getLoggingLocale(), this.cacheManagerNotClosed$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    @Override
    public final void leakedCacheManager(Throwable allocationStackTrace) {
        this.log.logf(FQCN, Logger.Level.WARN, allocationStackTrace, this.leakedCacheManager$str(), new Object[0]);
    }

    protected String leakedCacheManager$str() {
        return "ISPN021002: Closing leaked cache manager";
    }

    protected String methodWithoutCacheAnnotation$str() {
        return "ISPN021003: Method named '%s' is not annotated with CacheResult, CachePut, CacheRemoveEntry or CacheRemoveAll";
    }

    @Override
    public final IllegalArgumentException methodWithoutCacheAnnotation(String methodName) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.methodWithoutCacheAnnotation$str(), methodName));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cachePutMethodWithoutCacheValueParameter$str() {
        return "ISPN021004: Method named '%s' must have at least one parameter annotated with @CacheValue";
    }

    @Override
    public final CacheException cachePutMethodWithoutCacheValueParameter(String methodName) {
        CacheException result = new CacheException(String.format(this.getLoggingLocale(), this.cachePutMethodWithoutCacheValueParameter$str(), methodName));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cachePutMethodWithMoreThanOneCacheValueParameter$str() {
        return "ISPN021005: Method named '%s' must have only one parameter annotated with @CacheValue";
    }

    @Override
    public final CacheException cachePutMethodWithMoreThanOneCacheValueParameter(String methodName) {
        CacheException result = new CacheException(String.format(this.getLoggingLocale(), this.cachePutMethodWithMoreThanOneCacheValueParameter$str(), methodName));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cacheRemoveEntryMethodWithoutCacheName$str() {
        return "ISPN021006: Method named '%s' is annotated with CacheRemoveEntry but doesn't specify a cache name";
    }

    @Override
    public final CacheException cacheRemoveEntryMethodWithoutCacheName(String methodName) {
        CacheException result = new CacheException(String.format(this.getLoggingLocale(), this.cacheRemoveEntryMethodWithoutCacheName$str(), methodName));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cacheRemoveAllMethodWithoutCacheName$str() {
        return "ISPN021007: Method named '%s' is annotated with CacheRemoveAll but doesn't specify a cache name";
    }

    @Override
    public final CacheException cacheRemoveAllMethodWithoutCacheName(String methodName) {
        CacheException result = new CacheException(String.format(this.getLoggingLocale(), this.cacheRemoveAllMethodWithoutCacheName$str(), methodName));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unableToInstantiateCacheKeyGenerator$str() {
        return "ISPN021008: Unable to instantiate CacheKeyGenerator with type '%s'";
    }

    @Override
    public final CacheException unableToInstantiateCacheKeyGenerator(Class<?> type, Throwable cause) {
        CacheException result = new CacheException(String.format(this.getLoggingLocale(), this.unableToInstantiateCacheKeyGenerator$str(), type), cause);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String parameterMustNotBeNull$str() {
        return "ISPN021010: '%s' parameter must not be null";
    }

    @Override
    public final NullPointerException parameterMustNotBeNull(String parameterName) {
        NullPointerException result = new NullPointerException(String.format(this.getLoggingLocale(), this.parameterMustNotBeNull$str(), parameterName));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String incompatibleType$str() {
        return "ISPN021011: Incompatible cache value types specified, expected %s but %s was specified";
    }

    @Override
    public final ClassCastException incompatibleType(Class<?> type, Class<?> cfgType) {
        ClassCastException result = new ClassCastException(String.format(this.getLoggingLocale(), this.incompatibleType$str(), type, cfgType));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cacheAlreadyRegistered$str() {
        return "ISPN021015: Cache %s already registered with configuration %s, and can not be registered again with a new given configuration %s";
    }

    @Override
    public final CacheException cacheAlreadyRegistered(String cacheName, Configuration cacheCfg, Configuration newCfg) {
        CacheException result = new CacheException(String.format(this.getLoggingLocale(), this.cacheAlreadyRegistered$str(), cacheName, cacheCfg, newCfg));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unknownExpiryOperation$str() {
        return "ISPN021016: Unknown expiry operation: %s";
    }

    @Override
    public final IllegalStateException unknownExpiryOperation(String op) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.unknownExpiryOperation$str(), op));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String configurationClassNotSupported$str() {
        return "ISPN021018: The configuration class %s is not supported by this implementation";
    }

    @Override
    public final IllegalArgumentException configurationClassNotSupported(Class clazz) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.configurationClassNotSupported$str(), clazz));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String entryProcessingFailed$str() {
        return "ISPN021019: Entry processing failed";
    }

    @Override
    public final EntryProcessorException entryProcessingFailed(Throwable t) {
        EntryProcessorException result = new EntryProcessorException(String.format(this.getLoggingLocale(), this.entryProcessingFailed$str(), new Object[0]), t);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cacheNotFound$str() {
        return "ISPN021022: Cache named '%s' was not found.";
    }

    @Override
    public final CacheException cacheNotFound(String cacheName) {
        CacheException result = new CacheException(String.format(this.getLoggingLocale(), this.cacheNotFound$str(), cacheName));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cacheClosed$str() {
        return "ISPN021023: Cache is closed.";
    }

    @Override
    public final IllegalStateException cacheClosed() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.cacheClosed$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cacheManagerClosed$str() {
        return "ISPN021030: Cache manager is already closed.";
    }

    @Override
    public final IllegalStateException cacheManagerClosed() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.cacheManagerClosed$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void errorClosingCloseable(Closeable closeable, Exception e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, this.errorClosingCloseable$str(), (Object)closeable);
    }

    protected String errorClosingCloseable$str() {
        return "ISPN021031: Error closing %s";
    }

    @Override
    public final void getExpiryHasThrown(Throwable t) {
        this.log.logf(FQCN, Logger.Level.WARN, t, this.getExpiryHasThrown$str(), new Object[0]);
    }

    protected String getExpiryHasThrown$str() {
        return "ISPN021032: Exception while getting expiry duration. Fallback to default duration eternal.";
    }

    protected String unableToInstantiateCacheResolverFactory$str() {
        return "ISPN021033: Unable to instantiate CacheResolverFactory with type '%s'";
    }

    @Override
    public final CacheException unableToInstantiateCacheResolverFactory(Class<?> type, Throwable cause) {
        CacheException result = new CacheException(String.format(this.getLoggingLocale(), this.unableToInstantiateCacheResolverFactory$str(), type), cause);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }
}

