/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.system.stats.process;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.graylog2.shared.system.stats.SigarService;
import org.graylog2.shared.system.stats.process.JmxProcessProbe;
import org.graylog2.shared.system.stats.process.ProcessProbe;
import org.graylog2.shared.system.stats.process.ProcessStats;
import org.hyperic.sigar.ProcCpu;
import org.hyperic.sigar.ProcMem;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;

@Singleton
public class SigarProcessProbe
implements ProcessProbe {
    private final SigarService sigarService;

    @Inject
    public SigarProcessProbe(SigarService sigarService) {
        this.sigarService = sigarService;
    }

    @Override
    public synchronized ProcessStats processStats() {
        ProcessStats.Memory memory;
        ProcessStats.Cpu cpu;
        Sigar sigar = this.sigarService.sigar();
        long pid = sigar.getPid();
        long openFileDescriptors = JmxProcessProbe.getOpenFileDescriptorCount();
        long maxFileDescriptorCount = JmxProcessProbe.getMaxFileDescriptorCount();
        try {
            ProcCpu procCpu = sigar.getProcCpu(pid);
            cpu = ProcessStats.Cpu.create((short)(procCpu.getPercent() * 100.0), procCpu.getSys(), procCpu.getUser(), procCpu.getTotal());
        }
        catch (SigarException e) {
            cpu = null;
        }
        try {
            ProcMem mem = sigar.getProcMem(sigar.getPid());
            memory = ProcessStats.Memory.create(mem.getSize(), mem.getResident(), mem.getShare());
        }
        catch (SigarException e) {
            memory = null;
        }
        return ProcessStats.create(pid, openFileDescriptors, maxFileDescriptorCount, cpu, memory);
    }
}

