/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.system.stats.os;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.graylog2.shared.system.stats.SigarService;
import org.graylog2.shared.system.stats.os.Memory;
import org.graylog2.shared.system.stats.os.OsProbe;
import org.graylog2.shared.system.stats.os.OsStats;
import org.graylog2.shared.system.stats.os.Processor;
import org.graylog2.shared.system.stats.os.Swap;
import org.hyperic.sigar.CpuInfo;
import org.hyperic.sigar.CpuPerc;
import org.hyperic.sigar.Mem;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;

@Singleton
public class SigarOsProbe
implements OsProbe {
    private final SigarService sigarService;

    @Inject
    public SigarOsProbe(SigarService sigarService) {
        this.sigarService = sigarService;
    }

    @Override
    public OsStats osStats() {
        Swap swap;
        Memory memory;
        long used;
        Processor processor;
        long uptime;
        double[] loadAverage;
        Sigar sigar = this.sigarService.sigar();
        try {
            loadAverage = sigar.getLoadAverage();
        }
        catch (SigarException e) {
            loadAverage = OsStats.EMPTY_LOAD;
        }
        try {
            uptime = (long)sigar.getUptime().getUptime();
        }
        catch (SigarException e) {
            uptime = -1L;
        }
        try {
            CpuInfo[] cpuInfos = sigar.getCpuInfoList();
            String vendor = cpuInfos[0].getVendor();
            String model = cpuInfos[0].getModel();
            int mhz = cpuInfos[0].getMhz();
            int totalCores = cpuInfos[0].getTotalCores();
            int totalSockets = cpuInfos[0].getTotalSockets();
            int coresPerSocket = cpuInfos[0].getCoresPerSocket();
            long cacheSize = -1L;
            if (cpuInfos[0].getCacheSize() != -1L) {
                cacheSize = cpuInfos[0].getCacheSize();
            }
            CpuPerc cpuPerc = sigar.getCpuPerc();
            short sys = (short)(cpuPerc.getSys() * 100.0);
            short user = (short)(cpuPerc.getUser() * 100.0);
            short idle = (short)(cpuPerc.getIdle() * 100.0);
            short stolen = (short)(cpuPerc.getStolen() * 100.0);
            processor = Processor.create(model, vendor, mhz, totalCores, totalSockets, coresPerSocket, cacheSize, sys, user, idle, stolen);
        }
        catch (SigarException e) {
            processor = Processor.create("Unknown", "Unknown", -1, -1, -1, -1, -1L, (short)-1, (short)-1, (short)-1, (short)-1);
        }
        try {
            Mem mem = sigar.getMem();
            long total = mem.getTotal();
            long free = mem.getFree();
            short freePercent = (short)mem.getFreePercent();
            used = mem.getUsed();
            short usedPercent = (short)mem.getUsedPercent();
            long actualFree = mem.getActualFree();
            long actualUsed = mem.getActualUsed();
            memory = Memory.create(total, free, freePercent, used, usedPercent, actualFree, actualUsed);
        }
        catch (SigarException e) {
            memory = Memory.create(-1L, -1L, (short)-1, -1L, (short)-1, -1L, -1L);
        }
        try {
            org.hyperic.sigar.Swap sigSwap = sigar.getSwap();
            long total = sigSwap.getTotal();
            long free = sigSwap.getFree();
            used = sigSwap.getUsed();
            swap = Swap.create(total, free, used);
        }
        catch (SigarException e) {
            swap = Swap.create(-1L, -1L, -1L);
        }
        return OsStats.create(loadAverage, uptime, processor, memory, swap);
    }
}

