/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.security;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Locale;
import javax.annotation.Priority;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.SecurityContext;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog2.rest.RestTools;
import org.graylog2.shared.security.ContextAwarePermissionAnnotationHandler;
import org.graylog2.shared.security.ShiroSecurityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Priority(value=2000)
public class ShiroAuthorizationFilter
implements ContainerRequestFilter {
    private static final Logger LOG = LoggerFactory.getLogger(ShiroAuthorizationFilter.class);
    private final RequiresPermissions annotation;

    public ShiroAuthorizationFilter(RequiresPermissions annotation) {
        this.annotation = annotation;
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        SecurityContext securityContext = requestContext.getSecurityContext();
        if (securityContext instanceof ShiroSecurityContext) {
            ShiroSecurityContext context = (ShiroSecurityContext)securityContext;
            String userName = RestTools.getUserNameFromRequest(requestContext);
            ContextAwarePermissionAnnotationHandler annotationHandler = new ContextAwarePermissionAnnotationHandler(context);
            try {
                LOG.debug("Checking authorization for user [{}], needs permissions: {}", (Object)userName, (Object)this.annotation.value());
                annotationHandler.assertAuthorized((Annotation)this.annotation);
            }
            catch (AuthorizationException e) {
                String msg = String.format(Locale.US, "User [%s] not authorized. (%s %s)", userName, requestContext.getMethod(), requestContext.getUriInfo().getPath());
                LOG.info(msg);
                throw new ForbiddenException(msg);
            }
        } else {
            throw new ForbiddenException();
        }
    }
}

