/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.rest.exceptionmappers;

import com.fasterxml.jackson.databind.exc.PropertyBindingException;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import java.util.Collection;
import java.util.Collections;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.graylog2.plugin.rest.ApiError;

@Provider
public class JacksonPropertyExceptionMapper
implements ExceptionMapper<PropertyBindingException> {
    public Response toResponse(PropertyBindingException e) {
        Collection knownPropertyIds = (Collection)MoreObjects.firstNonNull((Object)e.getKnownPropertyIds(), Collections.emptyList());
        ApiError apiError = new ApiError("Unable to map property " + e.getPropertyName() + ".\nKnown properties include: " + Joiner.on((String)", ").join((Iterable)knownPropertyIds));
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)apiError).build();
    }
}

