/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.inputs;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.configuration.Configuration;
import org.graylog2.plugin.inputs.MessageInput;
import org.graylog2.rest.models.system.inputs.requests.InputCreateRequest;
import org.graylog2.shared.inputs.InputDescription;
import org.graylog2.shared.inputs.NoSuchInputTypeException;

public class MessageInputFactory {
    private final Map<String, MessageInput.Factory<? extends MessageInput>> inputFactories;

    @Inject
    public MessageInputFactory(Map<String, MessageInput.Factory<? extends MessageInput>> inputFactories) {
        this.inputFactories = inputFactories;
    }

    public MessageInput create(String type, Configuration configuration) throws NoSuchInputTypeException {
        if (this.inputFactories.containsKey(type)) {
            MessageInput.Factory<? extends MessageInput> factory = this.inputFactories.get(type);
            return factory.create(configuration);
        }
        throw new NoSuchInputTypeException("There is no input of type <" + type + "> registered.");
    }

    public MessageInput create(InputCreateRequest lr, String user, String nodeId) throws NoSuchInputTypeException {
        MessageInput input = this.create(lr.type(), new Configuration(lr.configuration()));
        input.setTitle(lr.title());
        input.setGlobal(lr.global());
        input.setCreatorUserId(user);
        input.setCreatedAt(Tools.nowUTC());
        if (!lr.global()) {
            input.setNodeId(nodeId);
        }
        return input;
    }

    public Map<String, InputDescription> getAvailableInputs() {
        HashMap result = Maps.newHashMap();
        for (Map.Entry<String, MessageInput.Factory<? extends MessageInput>> factories : this.inputFactories.entrySet()) {
            MessageInput.Factory<? extends MessageInput> factory = factories.getValue();
            MessageInput.Descriptor descriptor = factory.getDescriptor();
            MessageInput.Config config = factory.getConfig();
            InputDescription inputDescription = new InputDescription(descriptor, config);
            result.put(factories.getKey(), inputDescription);
        }
        return result;
    }
}

