/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system.indexer;

import com.codahale.metrics.annotation.Timed;
import com.google.common.collect.ImmutableMap;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.DELETE;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.indexer.IndexSet;
import org.graylog2.indexer.IndexSetRegistry;
import org.graylog2.indexer.NodeInfoCache;
import org.graylog2.indexer.indices.Indices;
import org.graylog2.indexer.indices.TooManyAliasesException;
import org.graylog2.indexer.indices.stats.IndexStatistics;
import org.graylog2.rest.models.system.indexer.requests.IndicesReadRequest;
import org.graylog2.rest.models.system.indexer.responses.AllIndices;
import org.graylog2.rest.models.system.indexer.responses.ClosedIndices;
import org.graylog2.rest.models.system.indexer.responses.IndexInfo;
import org.graylog2.rest.models.system.indexer.responses.OpenIndicesInfo;
import org.graylog2.rest.models.system.indexer.responses.ShardRouting;
import org.graylog2.shared.rest.resources.RestResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequiresAuthentication
@Api(value="Indexer/Indices", description="Index information")
@Path(value="/system/indexer/indices")
public class IndicesResource
extends RestResource {
    private static final Logger LOG = LoggerFactory.getLogger(IndicesResource.class);
    private final Indices indices;
    private final NodeInfoCache nodeInfoCache;
    private final IndexSetRegistry indexSetRegistry;

    @Inject
    public IndicesResource(Indices indices, NodeInfoCache nodeInfoCache, IndexSetRegistry indexSetRegistry) {
        this.indices = indices;
        this.nodeInfoCache = nodeInfoCache;
        this.indexSetRegistry = indexSetRegistry;
    }

    @GET
    @Timed
    @Path(value="/{index}")
    @ApiOperation(value="Get information of an index and its shards.")
    @Produces(value={"application/json"})
    public IndexInfo single(@ApiParam(name="index") @PathParam(value="index") String index) {
        this.checkPermission("indices:read", index);
        if (!this.indexSetRegistry.isManagedIndex(index)) {
            String msg = "Index [" + index + "]\u00a0doesn't look like an index managed by Graylog.";
            LOG.info(msg);
            throw new NotFoundException(msg);
        }
        return this.indices.getIndexStats(index).map(this::toIndexInfo).orElseThrow(() -> new NotFoundException("Index [" + index + "] not found."));
    }

    @POST
    @Timed
    @Path(value="/multiple")
    @ApiOperation(value="Get information of all specified indices and their shards.")
    @Produces(value={"application/json"})
    @NoAuditEvent(value="only used to request index information")
    public Map<String, IndexInfo> multiple(@ApiParam(name="Requested indices", required=true) @Valid @NotNull IndicesReadRequest request) {
        Set<String> requestedIndices = request.indices().stream().filter(index -> this.isPermitted("indices:read", (String)index)).collect(Collectors.toSet());
        Map<String, Boolean> managedStatus = this.indexSetRegistry.isManagedIndex(requestedIndices);
        Set<String> managedIndices = requestedIndices.stream().filter(index -> managedStatus.getOrDefault(index, false)).collect(Collectors.toSet());
        return this.toIndexInfos(this.indices.getIndicesStats(managedIndices));
    }

    @GET
    @Path(value="/open")
    @Timed
    @ApiOperation(value="Get information of all open indices managed by Graylog and their shards.")
    @RequiresPermissions(value={"indices:read"})
    @Produces(value={"application/json"})
    public OpenIndicesInfo open() {
        Set<IndexSet> indexSets = this.indexSetRegistry.getAll();
        Set<String> indexWildcards = indexSets.stream().map(IndexSet::getIndexWildcard).collect(Collectors.toSet());
        Set<IndexStatistics> indicesStats = this.indices.getIndicesStats(indexWildcards);
        return this.getOpenIndicesInfo(indicesStats);
    }

    @GET
    @Timed
    @Path(value="/closed")
    @ApiOperation(value="Get a list of closed indices that can be reopened.")
    @Produces(value={"application/json"})
    public ClosedIndices closed() {
        Set<IndexSet> indexSets = this.indexSetRegistry.getAll();
        Set<String> indexWildcards = indexSets.stream().map(IndexSet::getIndexWildcard).collect(Collectors.toSet());
        Set<String> closedIndices = this.indices.getClosedIndices(indexWildcards).stream().filter(index -> this.isPermitted("indices:read", (String)index)).collect(Collectors.toSet());
        return ClosedIndices.create(closedIndices, closedIndices.size());
    }

    @GET
    @Timed
    @Path(value="/reopened")
    @ApiOperation(value="Get a list of reopened indices, which will not be cleaned by retention cleaning")
    @Produces(value={"application/json"})
    public ClosedIndices reopened() {
        Set<IndexSet> indexSets = this.indexSetRegistry.getAll();
        Set<String> indexWildcards = indexSets.stream().map(IndexSet::getIndexWildcard).collect(Collectors.toSet());
        Set<String> reopenedIndices = this.indices.getReopenedIndices(indexWildcards).stream().filter(index -> this.isPermitted("indices:read", (String)index)).collect(Collectors.toSet());
        return ClosedIndices.create(reopenedIndices, reopenedIndices.size());
    }

    @GET
    @Timed
    @ApiOperation(value="List all open, closed and reopened indices.")
    @Produces(value={"application/json"})
    public AllIndices all() {
        return AllIndices.create(this.closed(), this.reopened(), this.open());
    }

    @POST
    @Timed
    @Path(value="/{index}/reopen")
    @ApiOperation(value="Reopen a closed index. This will also trigger an index ranges rebuild job.")
    @Produces(value={"application/json"})
    @AuditEvent(type="server:es_index:open")
    public void reopen(@ApiParam(name="index") @PathParam(value="index") String index) {
        this.checkPermission("indices:changestate", index);
        if (!this.indexSetRegistry.isManagedIndex(index)) {
            String msg = "Index [" + index + "]\u00a0doesn't look like an index managed by Graylog.";
            LOG.info(msg);
            throw new NotFoundException(msg);
        }
        this.indices.reopenIndex(index);
    }

    @POST
    @Timed
    @Path(value="/{index}/close")
    @ApiOperation(value="Close an index. This will also trigger an index ranges rebuild job.")
    @Produces(value={"application/json"})
    @ApiResponses(value={@ApiResponse(code=403, message="You cannot close the current deflector target index.")})
    @AuditEvent(type="server:es_index:close")
    public void close(@ApiParam(name="index") @PathParam(value="index") @NotNull String index) throws TooManyAliasesException {
        this.checkPermission("indices:changestate", index);
        if (!this.indexSetRegistry.isManagedIndex(index)) {
            String msg = "Index [" + index + "]\u00a0doesn't look like an index managed by Graylog.";
            LOG.info(msg);
            throw new NotFoundException(msg);
        }
        if (this.indexSetRegistry.isCurrentWriteIndex(index)) {
            throw new ForbiddenException("The current deflector target index (" + index + ") cannot be closed");
        }
        this.indices.close(index);
    }

    @DELETE
    @Timed
    @Path(value="/{index}")
    @ApiOperation(value="Delete an index. This will also trigger an index ranges rebuild job.")
    @Produces(value={"application/json"})
    @ApiResponses(value={@ApiResponse(code=403, message="You cannot delete the current deflector target index.")})
    @AuditEvent(type="server:es_index:delete")
    public void delete(@ApiParam(name="index") @PathParam(value="index") @NotNull String index) throws TooManyAliasesException {
        this.checkPermission("indices:delete", index);
        if (!this.indexSetRegistry.isManagedIndex(index)) {
            String msg = "Index [" + index + "]\u00a0doesn't look like an index managed by Graylog.";
            LOG.info(msg);
            throw new NotFoundException(msg);
        }
        if (this.indexSetRegistry.isCurrentWriteIndex(index)) {
            throw new ForbiddenException("The current deflector target index (" + index + ") cannot be deleted");
        }
        this.indices.delete(index);
    }

    @GET
    @Timed
    @Path(value="/{indexSetId}/list")
    @ApiOperation(value="List all open, closed and reopened indices.")
    @Produces(value={"application/json"})
    public AllIndices indexSetList(@ApiParam(name="indexSetId") @PathParam(value="indexSetId") String indexSetId) {
        return AllIndices.create(this.indexSetClosed(indexSetId), this.indexSetReopened(indexSetId), this.indexSetOpen(indexSetId));
    }

    @GET
    @Path(value="/{indexSetId}/open")
    @Timed
    @ApiOperation(value="Get information of all open indices managed by Graylog and their shards.")
    @RequiresPermissions(value={"indices:read"})
    @Produces(value={"application/json"})
    public OpenIndicesInfo indexSetOpen(@ApiParam(name="indexSetId") @PathParam(value="indexSetId") String indexSetId) {
        IndexSet indexSet = this.getIndexSet(this.indexSetRegistry, indexSetId);
        Set<IndexStatistics> indicesInfos = this.indices.getIndicesStats(indexSet).stream().filter(indexStats -> this.isPermitted("indices:read", indexStats.index())).collect(Collectors.toSet());
        return this.getOpenIndicesInfo(indicesInfos);
    }

    @GET
    @Timed
    @Path(value="/{indexSetId}/closed")
    @ApiOperation(value="Get a list of closed indices that can be reopened.")
    @Produces(value={"application/json"})
    public ClosedIndices indexSetClosed(@ApiParam(name="indexSetId") @PathParam(value="indexSetId") String indexSetId) {
        IndexSet indexSet = this.getIndexSet(this.indexSetRegistry, indexSetId);
        Set<String> closedIndices = this.indices.getClosedIndices(indexSet).stream().filter(index -> this.isPermitted("indices:read", (String)index)).collect(Collectors.toSet());
        return ClosedIndices.create(closedIndices, closedIndices.size());
    }

    @GET
    @Timed
    @Path(value="/{indexSetId}/reopened")
    @ApiOperation(value="Get a list of reopened indices, which will not be cleaned by retention cleaning")
    @Produces(value={"application/json"})
    public ClosedIndices indexSetReopened(@ApiParam(name="indexSetId") @PathParam(value="indexSetId") String indexSetId) {
        IndexSet indexSet = this.getIndexSet(this.indexSetRegistry, indexSetId);
        Set<String> reopenedIndices = this.indices.getReopenedIndices(indexSet).stream().filter(index -> this.isPermitted("indices:read", (String)index)).collect(Collectors.toSet());
        return ClosedIndices.create(reopenedIndices, reopenedIndices.size());
    }

    private OpenIndicesInfo getOpenIndicesInfo(Set<IndexStatistics> indicesStatistics) {
        HashMap<String, IndexInfo> indexInfos = new HashMap<String, IndexInfo>();
        Set<String> indices = indicesStatistics.stream().map(IndexStatistics::index).collect(Collectors.toSet());
        Map<String, Boolean> areReopened = this.indices.areReopened(indices);
        for (IndexStatistics indexStatistics : indicesStatistics) {
            IndexInfo indexInfo = IndexInfo.create(indexStatistics.primaryShards(), indexStatistics.allShards(), this.fillShardRoutings(indexStatistics.routing()), areReopened.get(indexStatistics.index()));
            indexInfos.put(indexStatistics.index(), indexInfo);
        }
        return OpenIndicesInfo.create(indexInfos);
    }

    private List<ShardRouting> fillShardRoutings(List<ShardRouting> shardRoutings) {
        return shardRoutings.stream().map(shardRouting -> shardRouting.withNodeDetails(this.nodeInfoCache.getNodeName(shardRouting.nodeId()).orElse(null), this.nodeInfoCache.getHostName(shardRouting.nodeId()).orElse(null))).collect(Collectors.toList());
    }

    private IndexInfo toIndexInfo(IndexStatistics indexStatistics) {
        return IndexInfo.create(indexStatistics.primaryShards(), indexStatistics.allShards(), this.fillShardRoutings(indexStatistics.routing()), this.indices.isReopened(indexStatistics.index()));
    }

    private Map<String, IndexInfo> toIndexInfos(Collection<IndexStatistics> indexStatistics) {
        Set<String> indexNames = indexStatistics.stream().map(IndexStatistics::index).collect(Collectors.toSet());
        Map<String, Boolean> reopenedStatus = this.indices.areReopened(indexNames);
        ImmutableMap.Builder indexInfos = ImmutableMap.builder();
        for (IndexStatistics indexStats : indexStatistics) {
            IndexInfo indexInfo = IndexInfo.create(indexStats.primaryShards(), indexStats.allShards(), this.fillShardRoutings(indexStats.routing()), reopenedStatus.getOrDefault(indexStats.index(), false));
            indexInfos.put((Object)indexStats.index(), (Object)indexInfo);
        }
        return indexInfos.build();
    }
}

