/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system.indexer;

import com.codahale.metrics.annotation.Timed;
import com.mongodb.DuplicateKeyException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.indexer.IndexSet;
import org.graylog2.indexer.IndexSetRegistry;
import org.graylog2.indexer.IndexSetStatsCreator;
import org.graylog2.indexer.IndexSetValidator;
import org.graylog2.indexer.indexset.DefaultIndexSetConfig;
import org.graylog2.indexer.indexset.IndexSetConfig;
import org.graylog2.indexer.indexset.IndexSetService;
import org.graylog2.indexer.indices.jobs.IndexSetCleanupJob;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.rest.resources.system.indexer.requests.IndexSetUpdateRequest;
import org.graylog2.rest.resources.system.indexer.responses.IndexSetResponse;
import org.graylog2.rest.resources.system.indexer.responses.IndexSetStats;
import org.graylog2.rest.resources.system.indexer.responses.IndexSetSummary;
import org.graylog2.shared.rest.resources.RestResource;
import org.graylog2.system.jobs.SystemJobConcurrencyException;
import org.graylog2.system.jobs.SystemJobManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequiresAuthentication
@Api(value="System/IndexSets", description="Index sets")
@Path(value="/system/indices/index_sets")
@Produces(value={"application/json"})
public class IndexSetsResource
extends RestResource {
    private static final Logger LOG = LoggerFactory.getLogger(IndexSetsResource.class);
    private final IndexSetService indexSetService;
    private final IndexSetRegistry indexSetRegistry;
    private final IndexSetValidator indexSetValidator;
    private final IndexSetCleanupJob.Factory indexSetCleanupJobFactory;
    private final IndexSetStatsCreator indexSetStatsCreator;
    private final ClusterConfigService clusterConfigService;
    private final SystemJobManager systemJobManager;

    @Inject
    public IndexSetsResource(IndexSetService indexSetService, IndexSetRegistry indexSetRegistry, IndexSetValidator indexSetValidator, IndexSetCleanupJob.Factory indexSetCleanupJobFactory, IndexSetStatsCreator indexSetStatsCreator, ClusterConfigService clusterConfigService, SystemJobManager systemJobManager) {
        this.indexSetService = Objects.requireNonNull(indexSetService);
        this.indexSetRegistry = indexSetRegistry;
        this.indexSetValidator = indexSetValidator;
        this.indexSetCleanupJobFactory = Objects.requireNonNull(indexSetCleanupJobFactory);
        this.indexSetStatsCreator = indexSetStatsCreator;
        this.clusterConfigService = clusterConfigService;
        this.systemJobManager = systemJobManager;
    }

    @GET
    @Timed
    @ApiOperation(value="Get a list of all index sets")
    @ApiResponses(value={@ApiResponse(code=403, message="Unauthorized")})
    public IndexSetResponse list(@ApiParam(name="skip", value="The number of elements to skip (offset).", required=true) @QueryParam(value="skip") @DefaultValue(value="0") int skip, @ApiParam(name="limit", value="The maximum number of elements to return.", required=true) @QueryParam(value="limit") @DefaultValue(value="0") int limit, @ApiParam(name="stats", value="Include index set stats.") @QueryParam(value="stats") @DefaultValue(value="false") boolean computeStats) {
        int count;
        List<IndexSetSummary> indexSets;
        IndexSetConfig defaultIndexSet = this.indexSetService.getDefault();
        if (limit > 0) {
            Set<String> allowedIds = this.indexSetService.findAll().stream().filter(indexSet -> this.isPermitted("indexsets:read", indexSet.id())).map(IndexSetConfig::id).collect(Collectors.toSet());
            indexSets = this.indexSetService.findPaginated(allowedIds, limit, skip).stream().map(config -> IndexSetSummary.fromIndexSetConfig(config, config.equals(defaultIndexSet))).collect(Collectors.toList());
            count = allowedIds.size();
        } else {
            indexSets = this.indexSetService.findAll().stream().filter(indexSetConfig -> this.isPermitted("indexsets:read", indexSetConfig.id())).map(config -> IndexSetSummary.fromIndexSetConfig(config, config.equals(defaultIndexSet))).collect(Collectors.toList());
            count = indexSets.size();
        }
        Map<String, IndexSetStats> stats = computeStats ? this.indexSetRegistry.getAll().stream().collect(Collectors.toMap(indexSet -> indexSet.getConfig().id(), this.indexSetStatsCreator::getForIndexSet)) : Collections.emptyMap();
        return IndexSetResponse.create(count, indexSets, stats);
    }

    @GET
    @Path(value="{id}")
    @Timed
    @ApiOperation(value="Get index set")
    @ApiResponses(value={@ApiResponse(code=403, message="Unauthorized"), @ApiResponse(code=404, message="Index set not found")})
    public IndexSetSummary get(@ApiParam(name="id", required=true) @PathParam(value="id") String id) {
        this.checkPermission("indexsets:read", id);
        IndexSetConfig defaultIndexSet = this.indexSetService.getDefault();
        return this.indexSetService.get(id).map(config -> IndexSetSummary.fromIndexSetConfig(config, config.equals(defaultIndexSet))).orElseThrow(() -> new NotFoundException("Couldn't load index set with ID <" + id + ">"));
    }

    @POST
    @Timed
    @ApiOperation(value="Create index set")
    @RequiresPermissions(value={"indexsets:create"})
    @Consumes(value={"application/json"})
    @AuditEvent(type="server:index_set:create")
    @ApiResponses(value={@ApiResponse(code=403, message="Unauthorized")})
    public IndexSetSummary save(@ApiParam(name="Index set configuration", required=true) @Valid @NotNull IndexSetSummary indexSet) {
        try {
            IndexSetConfig indexSetConfig = indexSet.toIndexSetConfig();
            Optional<IndexSetValidator.Violation> violation = this.indexSetValidator.validate(indexSetConfig);
            if (violation.isPresent()) {
                throw new BadRequestException(violation.get().message());
            }
            IndexSetConfig savedObject = this.indexSetService.save(indexSetConfig);
            IndexSetConfig defaultIndexSet = this.indexSetService.getDefault();
            return IndexSetSummary.fromIndexSetConfig(savedObject, savedObject.equals(defaultIndexSet));
        }
        catch (DuplicateKeyException e) {
            throw new BadRequestException(e.getMessage());
        }
    }

    @PUT
    @Path(value="{id}")
    @Timed
    @ApiOperation(value="Update index set")
    @AuditEvent(type="server:index_set:update")
    @ApiResponses(value={@ApiResponse(code=403, message="Unauthorized"), @ApiResponse(code=409, message="Mismatch of IDs in URI path and payload")})
    public IndexSetSummary update(@ApiParam(name="id", required=true) @PathParam(value="id") String id, @ApiParam(name="Index set configuration", required=true) @Valid @NotNull IndexSetUpdateRequest updateRequest) {
        this.checkPermission("indexsets:edit", id);
        IndexSetConfig oldConfig = this.indexSetService.get(id).orElseThrow(() -> new NotFoundException("Index set <" + id + "> not found"));
        IndexSetConfig defaultIndexSet = this.indexSetService.getDefault();
        boolean isDefaultSet = oldConfig.equals(defaultIndexSet);
        if (isDefaultSet && !updateRequest.isWritable()) {
            throw new ClientErrorException("Default index set must be writable.", Response.Status.CONFLICT);
        }
        IndexSetConfig savedObject = this.indexSetService.save(updateRequest.toIndexSetConfig(id, oldConfig));
        return IndexSetSummary.fromIndexSetConfig(savedObject, isDefaultSet);
    }

    @PUT
    @Path(value="{id}/default")
    @Timed
    @ApiOperation(value="Set default index set")
    @AuditEvent(type="server:index_set:update")
    @ApiResponses(value={@ApiResponse(code=403, message="Unauthorized")})
    public IndexSetSummary setDefault(@ApiParam(name="id", required=true) @PathParam(value="id") String id) {
        this.checkPermission("indexsets:edit", id);
        IndexSetConfig indexSet = this.indexSetService.get(id).orElseThrow(() -> new NotFoundException("Index set <" + id + "> does not exist"));
        if (!indexSet.isWritable()) {
            throw new ClientErrorException("Default index set must be writable.", Response.Status.CONFLICT);
        }
        this.clusterConfigService.write(DefaultIndexSetConfig.create(indexSet.id()));
        IndexSetConfig defaultIndexSet = this.indexSetService.getDefault();
        return IndexSetSummary.fromIndexSetConfig(indexSet, indexSet.equals(defaultIndexSet));
    }

    @DELETE
    @Path(value="{id}")
    @Timed
    @ApiOperation(value="Delete index set")
    @AuditEvent(type="server:index_set:delete")
    @ApiResponses(value={@ApiResponse(code=403, message="Unauthorized"), @ApiResponse(code=404, message="Index set not found")})
    public void delete(@ApiParam(name="id", required=true) @PathParam(value="id") String id, @ApiParam(name="delete_indices") @QueryParam(value="delete_indices") @DefaultValue(value="true") boolean deleteIndices) {
        this.checkPermission("indexsets:delete", id);
        IndexSet indexSet = this.getIndexSet(this.indexSetRegistry, id);
        IndexSet defaultIndexSet = this.indexSetRegistry.getDefault();
        if (indexSet.equals(defaultIndexSet)) {
            throw new BadRequestException("Default index set <" + indexSet.getConfig().id() + "> cannot be deleted!");
        }
        if (this.indexSetService.delete(id) == 0) {
            throw new NotFoundException("Couldn't delete index set with ID <" + id + ">");
        }
        if (deleteIndices) {
            try {
                this.systemJobManager.submit(this.indexSetCleanupJobFactory.create(indexSet));
            }
            catch (SystemJobConcurrencyException e) {
                LOG.error("Error running system job", (Throwable)e);
            }
        }
    }
}

