/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.cluster;

import com.codahale.metrics.annotation.Timed;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.ServiceUnavailableException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.cluster.Node;
import org.graylog2.cluster.NodeService;
import org.graylog2.rest.RemoteInterfaceProvider;
import org.graylog2.shared.rest.resources.ProxiedResource;
import org.graylog2.shared.rest.resources.system.RemoteDeflectorResource;

@RequiresAuthentication
@Api(value="Cluster/Deflector", description="Cluster-wide deflector handling")
@Path(value="/cluster/deflector")
@Produces(value={"application/json"})
public class ClusterDeflectorResource
extends ProxiedResource {
    @Inject
    public ClusterDeflectorResource(@Context HttpHeaders httpHeaders, NodeService nodeService, RemoteInterfaceProvider remoteInterfaceProvider, @Named(value="proxiedRequestsExecutorService") ExecutorService executorService) {
        super(httpHeaders, nodeService, remoteInterfaceProvider, executorService);
    }

    @POST
    @Timed
    @ApiOperation(value="Finds master node and triggers deflector cycle")
    @Path(value="/cycle")
    @NoAuditEvent(value="this is a proxy resource, the event will be triggered on the individual nodes")
    public void cycle() throws IOException {
        this.getDeflectorResource().cycle().execute();
    }

    @POST
    @Timed
    @ApiOperation(value="Finds master node and triggers deflector cycle")
    @Path(value="/{indexSetId}/cycle")
    @NoAuditEvent(value="this is a proxy resource, the event will be triggered on the individual nodes")
    public void cycle(@ApiParam(name="indexSetId") @PathParam(value="indexSetId") String indexSetId) throws IOException {
        this.getDeflectorResource().cycleIndexSet(indexSetId).execute();
    }

    private RemoteDeflectorResource getDeflectorResource() {
        Node master = this.findMasterNode();
        Function<String, Optional<RemoteDeflectorResource>> remoteInterfaceProvider = this.createRemoteInterfaceProvider(RemoteDeflectorResource.class);
        Optional<RemoteDeflectorResource> deflectorResource = remoteInterfaceProvider.apply(master.getNodeId());
        return deflectorResource.orElseThrow(() -> new InternalServerErrorException("Unable to get remote deflector resource."));
    }

    private Node findMasterNode() {
        return this.nodeService.allActive().values().stream().filter(Node::isMaster).findFirst().orElseThrow(() -> new ServiceUnavailableException("No master present."));
    }
}

