/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.plugin.database;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.graylog2.plugin.database.validators.ValidationResult;

public class ValidationException
extends Exception {
    private final Map<String, List<ValidationResult>> errors;

    public ValidationException(Map<String, List<ValidationResult>> errors) {
        this.errors = ImmutableMap.copyOf(errors);
    }

    public ValidationException(String message) {
        this("_", message);
    }

    public ValidationException(String field, String message) {
        super(message);
        this.errors = ImmutableMap.of((Object)field, Collections.singletonList(new ValidationResult.ValidationFailed(message)));
    }

    public Map<String, List<ValidationResult>> getErrors() {
        return this.errors;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("message", (Object)this.getLocalizedMessage()).add("errors", this.errors).toString();
    }
}

