/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.lookup;

import java.util.concurrent.ConcurrentMap;
import java.util.stream.Stream;
import org.graylog2.lookup.LookupTable;
import org.graylog2.plugin.lookup.LookupCache;
import org.graylog2.plugin.lookup.LookupCacheKey;
import org.graylog2.plugin.lookup.LookupCachePurge;
import org.graylog2.plugin.lookup.LookupDataAdapter;

public class CachePurge
implements LookupCachePurge {
    private final ConcurrentMap<String, LookupTable> tables;
    private final LookupDataAdapter adapter;

    public CachePurge(ConcurrentMap<String, LookupTable> tables, LookupDataAdapter adapter) {
        this.tables = tables;
        this.adapter = adapter;
    }

    @Override
    public void purgeAll() {
        this.caches().forEach(cache -> cache.purge(LookupCacheKey.prefix(this.adapter)));
    }

    @Override
    public void purgeKey(Object key) {
        this.caches().forEach(cache -> cache.purge(LookupCacheKey.create(this.adapter, key)));
    }

    private Stream<LookupCache> caches() {
        return this.tables.values().stream().filter(table -> table.dataAdapter().id().equals(this.adapter.id())).map(LookupTable::cache);
    }
}

