/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.jersey;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.ext.Provider;
import org.glassfish.jersey.server.model.ModelProcessor;
import org.glassfish.jersey.server.model.Resource;
import org.glassfish.jersey.server.model.ResourceModel;

@Provider
public class PrefixAddingModelProcessor
implements ModelProcessor {
    private final Map<String, String> packagePrefixes;

    public PrefixAddingModelProcessor(Map<String, String> packagePrefixes) {
        this.packagePrefixes = ImmutableMap.copyOf(packagePrefixes);
    }

    public ResourceModel processResourceModel(ResourceModel model, Configuration config) {
        ResourceModel.Builder resourceModelBuilder = new ResourceModel.Builder(false);
        for (Resource resource : model.getResources()) {
            for (Class handlerClass : resource.getHandlerClasses()) {
                String packageName = handlerClass.getPackage().getName();
                Optional<String> packagePrefix = this.packagePrefixes.entrySet().stream().filter(entry -> packageName.startsWith((String)entry.getKey())).sorted((o1, o2) -> -((String)o1.getKey()).compareTo((String)o2.getKey())).map(Map.Entry::getValue).findFirst();
                if (packagePrefix.isPresent()) {
                    String prefixedPath = this.prefixPath(packagePrefix.get(), resource.getPath());
                    Resource newResource = Resource.builder((Resource)resource).path(prefixedPath).build();
                    resourceModelBuilder.addResource(newResource);
                    continue;
                }
                resourceModelBuilder.addResource(resource);
            }
        }
        return resourceModelBuilder.build();
    }

    private String prefixPath(String prefix, String path) {
        String sanitizedPrefix = prefix.endsWith("/") ? prefix : prefix + "/";
        String sanitizedPath = path.startsWith("/") ? path.substring(1) : path;
        return sanitizedPrefix + sanitizedPath;
    }

    public ResourceModel processSubResource(ResourceModel model, Configuration config) {
        return model;
    }
}

