/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.filters;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import javax.inject.Named;
import org.graylog2.database.NotFoundException;
import org.graylog2.filters.FilterService;
import org.graylog2.filters.events.FilterDescriptionUpdateEvent;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.RulesEngine;
import org.graylog2.plugin.filters.MessageFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RulesFilter
implements MessageFilter {
    private static final Logger LOG = LoggerFactory.getLogger(RulesFilter.class);
    private final RulesEngine rulesEngine;
    private final FilterService filterService;
    private final ScheduledExecutorService scheduler;
    private final AtomicReference<RulesEngine.RulesSession> privateSession = new AtomicReference<Object>(null);

    @Inject
    public RulesFilter(RulesEngine rulesEngine, FilterService filterService, EventBus serverEventBus, @Named(value="daemonScheduler") ScheduledExecutorService scheduler) {
        this.rulesEngine = rulesEngine;
        this.filterService = filterService;
        this.scheduler = scheduler;
        this.loadRules();
        serverEventBus.register((Object)this);
    }

    @Override
    public boolean filter(Message msg) {
        this.privateSession.get().evaluate(msg, true);
        return msg.getFilterOut();
    }

    @Subscribe
    public void handleRulesUpdate(FilterDescriptionUpdateEvent ignored) {
        LOG.debug("Updating filter descriptions: {}", (Object)ignored);
        this.scheduler.submit(this::loadRules);
    }

    private void loadRules() {
        LOG.debug("Loading rule filters");
        try {
            RulesEngine.RulesSession newSession = this.rulesEngine.createPrivateSession();
            this.filterService.loadAll().forEach(filterDescription -> {
                LOG.debug("Insert filter description: {}", filterDescription);
                newSession.insertFact(filterDescription);
            });
            this.privateSession.set(newSession);
        }
        catch (NotFoundException e) {
            LOG.error("No filters found", (Throwable)e);
        }
    }

    @Override
    public String getName() {
        return "Rulesfilter";
    }

    @Override
    public int getPriority() {
        return 30;
    }
}

