/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.dashboards.widgets.strategies;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.graylog2.dashboards.widgets.InvalidWidgetConfigurationException;
import org.graylog2.dashboards.widgets.strategies.ChartWidgetStrategy;
import org.graylog2.indexer.FieldTypeException;
import org.graylog2.indexer.results.HistogramResult;
import org.graylog2.indexer.searches.Searches;
import org.graylog2.plugin.dashboards.widgets.ComputationResult;
import org.graylog2.plugin.dashboards.widgets.WidgetStrategy;
import org.graylog2.plugin.indexer.searches.timeranges.AbsoluteRange;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StackedChartWidgetStrategy
extends ChartWidgetStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(StackedChartWidgetStrategy.class);
    private final List<Series> chartSeries;
    private final Searches searches;
    private final TimeRange timeRange;
    private final String widgetId;

    @AssistedInject
    public StackedChartWidgetStrategy(Searches searches, @Assisted Map<String, Object> config, @Assisted TimeRange timeRange, @Assisted String widgetId) throws InvalidWidgetConfigurationException {
        super(config);
        this.searches = searches;
        this.timeRange = timeRange;
        this.widgetId = widgetId;
        if (!this.checkConfig(config)) {
            throw new InvalidWidgetConfigurationException("Missing or invalid widget configuration. Provided config was: " + config.toString());
        }
        Object persistedSeries = config.get("series");
        if (persistedSeries instanceof List) {
            List chartSeries = (List)persistedSeries;
            this.chartSeries = new ArrayList<Series>(chartSeries.size());
            for (Object series : chartSeries) {
                this.chartSeries.add(Series.fromMap((Map)series));
            }
        } else {
            throw new InvalidWidgetConfigurationException("Invalid widget configuration, 'series' should be a list: " + config.toString());
        }
    }

    @Override
    public ComputationResult compute() {
        String filter = null;
        if (!Strings.isNullOrEmpty((String)this.streamId)) {
            filter = "streams:" + this.streamId;
        }
        ArrayList<Map> results = new ArrayList<Map>(this.chartSeries.size());
        DateTime from = null;
        DateTime to = null;
        long tookMs = 0L;
        for (Series series : this.chartSeries) {
            try {
                HistogramResult histogramResult = this.searches.fieldHistogram(series.query, series.field, Searches.DateHistogramInterval.valueOf(this.interval.toString().toUpperCase(Locale.ENGLISH)), filter, this.timeRange, "cardinality".equalsIgnoreCase(series.statisticalFunction));
                if (from == null) {
                    from = histogramResult.getHistogramBoundaries().getFrom();
                }
                to = histogramResult.getHistogramBoundaries().getTo();
                results.add(histogramResult.getResults());
                tookMs += histogramResult.tookMs();
            }
            catch (FieldTypeException e) {
                String msg = "Could not calculate [" + this.getClass().getCanonicalName() + "] widget <" + this.widgetId + ">. Not a numeric field? The field was [" + series.field + "]";
                LOG.error(msg, (Throwable)e);
                throw new RuntimeException(msg, e);
            }
        }
        AbsoluteRange computationTimeRange = AbsoluteRange.create(from, to);
        return new ComputationResult(results, tookMs, computationTimeRange);
    }

    private boolean checkConfig(Map<String, Object> config) {
        return config.containsKey("renderer") && config.containsKey("interpolation") && config.containsKey("interval") && config.containsKey("series");
    }

    private static class Series {
        final String field;
        final String query;
        final String statisticalFunction;

        public static Series fromMap(Map<String, Object> fields) {
            return new Series((String)fields.get("query"), (String)fields.get("field"), (String)fields.get("statistical_function"));
        }

        Series(String query, String field, String statisticalFunction) {
            this.query = query == null || query.trim().isEmpty() ? "*" : query;
            this.field = field;
            this.statisticalFunction = statisticalFunction;
        }

        public Map<String, Object> toMap() {
            ImmutableMap.Builder mapBuilder = ImmutableMap.builder().put((Object)"query", (Object)this.query).put((Object)"field", (Object)this.field).put((Object)"statistical_function", (Object)this.statisticalFunction);
            return mapBuilder.build();
        }
    }

    public static interface Factory
    extends WidgetStrategy.Factory<StackedChartWidgetStrategy> {
        @Override
        public StackedChartWidgetStrategy create(Map<String, Object> var1, TimeRange var2, String var3);
    }
}

