/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.dashboards.widgets.strategies;

import com.google.common.collect.Maps;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.util.HashMap;
import java.util.Map;
import org.graylog2.indexer.results.CountResult;
import org.graylog2.indexer.searches.Searches;
import org.graylog2.plugin.dashboards.widgets.ComputationResult;
import org.graylog2.plugin.dashboards.widgets.WidgetStrategy;
import org.graylog2.plugin.indexer.searches.timeranges.AbsoluteRange;
import org.graylog2.plugin.indexer.searches.timeranges.RelativeRange;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;
import org.joda.time.DateTime;
import org.joda.time.ReadablePeriod;
import org.joda.time.Seconds;

public class SearchResultCountWidgetStrategy
implements WidgetStrategy {
    protected final Searches searches;
    protected final String query;
    protected final TimeRange timeRange;
    protected final Boolean trend;
    protected final Boolean lowerIsBetter;

    @AssistedInject
    public SearchResultCountWidgetStrategy(Searches searches, @Assisted Map<String, Object> config, @Assisted TimeRange timeRange, @Assisted String widgetId) {
        this.searches = searches;
        this.query = (String)config.get("query");
        this.timeRange = timeRange;
        this.trend = config.get("trend") != null && Boolean.parseBoolean(String.valueOf(config.get("trend")));
        this.lowerIsBetter = config.get("lower_is_better") != null && Boolean.parseBoolean(String.valueOf(config.get("lower_is_better")));
    }

    protected Searches getSearches() {
        return this.searches;
    }

    @Override
    public ComputationResult compute() {
        return this.computeInternal(null);
    }

    protected ComputationResult computeInternal(String filter) {
        TimeRange timeRange = this.timeRange;
        CountResult cr = this.searches.count(this.query, timeRange, filter);
        if (this.trend.booleanValue() && timeRange instanceof RelativeRange) {
            DateTime toPrevious = timeRange.getFrom();
            DateTime fromPrevious = toPrevious.minus((ReadablePeriod)Seconds.seconds((int)((RelativeRange)timeRange).getRange()));
            AbsoluteRange previousTimeRange = AbsoluteRange.create(fromPrevious, toPrevious);
            CountResult previousCr = this.searches.count(this.query, previousTimeRange);
            HashMap results = Maps.newHashMap();
            results.put("now", cr.count());
            results.put("previous", previousCr.count());
            long tookMs = cr.tookMs() + previousCr.tookMs();
            return new ComputationResult(results, tookMs);
        }
        return new ComputationResult(cr.count(), cr.tookMs());
    }

    public static interface Factory
    extends WidgetStrategy.Factory<SearchResultCountWidgetStrategy> {
        @Override
        public SearchResultCountWidgetStrategy create(Map<String, Object> var1, TimeRange var2, String var3);
    }
}

