/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.dashboards.widgets;

import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.mongodb.BasicDBObject;
import java.util.Map;
import java.util.UUID;
import javax.inject.Inject;
import org.graylog2.dashboards.widgets.DashboardWidget;
import org.graylog2.dashboards.widgets.InvalidWidgetConfigurationException;
import org.graylog2.dashboards.widgets.WidgetCacheTime;
import org.graylog2.plugin.indexer.searches.timeranges.InvalidRangeParametersException;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;
import org.graylog2.rest.models.dashboards.requests.AddWidgetRequest;
import org.graylog2.timeranges.TimeRangeFactory;

public class DashboardWidgetCreator {
    private final WidgetCacheTime.Factory cacheTimeFactory;
    private final TimeRangeFactory timeRangeFactory;

    @Inject
    public DashboardWidgetCreator(WidgetCacheTime.Factory cacheTimeFactory, TimeRangeFactory timeRangeFactory) {
        this.cacheTimeFactory = cacheTimeFactory;
        this.timeRangeFactory = timeRangeFactory;
    }

    public DashboardWidget fromRequest(AddWidgetRequest awr, String userId) throws DashboardWidget.NoSuchWidgetTypeException, InvalidRangeParametersException, InvalidWidgetConfigurationException {
        return this.fromRequest(null, awr, userId);
    }

    public DashboardWidget fromRequest(String widgetId, AddWidgetRequest awr, String userId) throws DashboardWidget.NoSuchWidgetTypeException, InvalidRangeParametersException, InvalidWidgetConfigurationException {
        String id = Strings.isNullOrEmpty((String)widgetId) ? UUID.randomUUID().toString() : widgetId;
        Map timerangeConfig = (Map)awr.config().get("timerange");
        TimeRange timeRange = this.timeRangeFactory.create(timerangeConfig);
        return this.buildDashboardWidget(awr.type(), id, awr.description(), 0, awr.config(), timeRange, userId);
    }

    public DashboardWidget fromPersisted(BasicDBObject fields) throws DashboardWidget.NoSuchWidgetTypeException, InvalidRangeParametersException, InvalidWidgetConfigurationException {
        String type = (String)fields.get("type");
        BasicDBObject config = (BasicDBObject)fields.get("config");
        String widgetId = (String)fields.get("id");
        BasicDBObject timerangeConfig = (BasicDBObject)config.get("timerange");
        TimeRange timeRange = this.timeRangeFactory.create((Map<String, Object>)timerangeConfig);
        String description = (String)fields.get("description");
        int cacheTime = (Integer)MoreObjects.firstNonNull((Object)fields.get("cache_time"), (Object)0);
        return this.buildDashboardWidget(type, widgetId, description, cacheTime, (Map<String, Object>)config, timeRange, (String)fields.get("creator_user_id"));
    }

    public DashboardWidget buildDashboardWidget(String type, String widgetId, String description, int requestedCacheTime, Map<String, Object> config, TimeRange timeRange, String creatorUserId) throws DashboardWidget.NoSuchWidgetTypeException, InvalidWidgetConfigurationException {
        WidgetCacheTime cacheTime = this.cacheTimeFactory.create(requestedCacheTime);
        return new DashboardWidget(type, widgetId, timeRange, description, cacheTime, config, creatorUserId);
    }
}

