/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.bindings;

import com.google.inject.Binder;
import com.google.inject.multibindings.MapBinder;
import org.graylog2.bindings.providers.DefaultPasswordAlgorithmProvider;
import org.graylog2.plugin.inject.Graylog2Module;
import org.graylog2.plugin.security.PasswordAlgorithm;
import org.graylog2.security.hashing.BCryptPasswordAlgorithm;
import org.graylog2.security.hashing.SHA1HashPasswordAlgorithm;
import org.graylog2.users.DefaultPasswordAlgorithm;

public class PasswordAlgorithmBindings
extends Graylog2Module {
    protected void configure() {
        this.bindPasswordAlgorithms();
    }

    private void bindPasswordAlgorithms() {
        MapBinder passwordAlgorithms = MapBinder.newMapBinder((Binder)this.binder(), String.class, PasswordAlgorithm.class);
        passwordAlgorithms.addBinding((Object)"sha-1").to(SHA1HashPasswordAlgorithm.class);
        passwordAlgorithms.addBinding((Object)"bcrypt").to(BCryptPasswordAlgorithm.class);
        this.bind(PasswordAlgorithm.class).annotatedWith(DefaultPasswordAlgorithm.class).toProvider(DefaultPasswordAlgorithmProvider.class);
    }
}

