/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.buildtools.maven;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.util.graph.visitor.PreorderNodeListGenerator;
import org.graalvm.buildtools.maven.AbstractNativeMojo;
import org.graalvm.buildtools.utils.DynamicAccessMetadataUtils;
import org.graalvm.reachability.internal.FileSystemRepository;

@Mojo(name="generateDynamicAccessMetadata", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, requiresDependencyResolution=ResolutionScope.RUNTIME, requiresDependencyCollection=ResolutionScope.RUNTIME)
public class NativeBuildDynamicAccessMetadataMojo
extends AbstractNativeMojo {
    private static final String LIBRARY_AND_FRAMEWORK_LIST = "library-and-framework-list.json";
    @Component
    private RepositorySystem repoSystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    private RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true)
    private List<RemoteRepository> remoteRepos;
    @Parameter(defaultValue="${project.build.directory}/dynamic-access-metadata.json", required=true)
    private File outputJson;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.configureMetadataRepository();
        File jsonFile = ((FileSystemRepository)this.metadataRepository).getRootDirectory().resolve(LIBRARY_AND_FRAMEWORK_LIST).toFile();
        if (!jsonFile.exists()) {
            this.getLog().warn((CharSequence)"library-and-framework-list.json is not packaged with the provided reachability metadata repository.");
            return;
        }
        try {
            Set artifactsToInclude = DynamicAccessMetadataUtils.readArtifacts((File)jsonFile);
            HashMap<String, String> coordinatesToPath = new HashMap<String, String>();
            for (org.apache.maven.artifact.Artifact artifact : this.project.getArtifacts()) {
                File file = artifact.getFile();
                if (file == null) continue;
                String coordinates = artifact.getGroupId() + ":" + artifact.getArtifactId();
                coordinatesToPath.put(coordinates, file.getAbsolutePath());
            }
            Map<String, Set<String>> exportMap = this.buildExportMap(artifactsToInclude, coordinatesToPath);
            this.serializeExportMap(this.outputJson, exportMap);
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)("Failed generating dynamic access metadata: " + String.valueOf(e)));
        }
        catch (DependencyCollectionException e) {
            this.getLog().warn((CharSequence)("Failed collecting dependencies: " + String.valueOf((Object)e)));
        }
    }

    private Map<String, Set<String>> buildExportMap(Set<String> artifactsToInclude, Map<String, String> coordinatesToPath) throws DependencyCollectionException {
        HashMap<String, Set<String>> exportMap = new HashMap<String, Set<String>>();
        for (org.apache.maven.artifact.Artifact artifact : this.project.getArtifacts()) {
            String coordinates = artifact.getGroupId() + ":" + artifact.getArtifactId();
            if (!artifactsToInclude.contains(coordinates) || artifact.getFile() == null) continue;
            Set<String> transitiveDependencies = this.collectDependencies(artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion(), coordinatesToPath);
            exportMap.put(artifact.getFile().getAbsolutePath(), transitiveDependencies);
        }
        return exportMap;
    }

    private Set<String> collectDependencies(String coordinates, Map<String, String> coordinatesToPath) throws DependencyCollectionException {
        DefaultArtifact artifact = new DefaultArtifact(coordinates);
        CollectRequest collectRequest = new CollectRequest();
        collectRequest.setRoot(new Dependency((Artifact)artifact, ""));
        collectRequest.setRepositories(this.remoteRepos);
        DependencyNode node = this.repoSystem.collectDependencies(this.repoSession, collectRequest).getRoot();
        PreorderNodeListGenerator nlg = new PreorderNodeListGenerator();
        node.accept((DependencyVisitor)nlg);
        LinkedHashSet<String> dependencies = new LinkedHashSet<String>();
        nlg.getNodes().forEach(dependencyNode -> {
            DefaultArtifact dependencyArtifact;
            String dependencyPath;
            if (dependencyNode.getDependency() != null && (dependencyPath = (String)coordinatesToPath.get((dependencyArtifact = (DefaultArtifact)dependencyNode.getDependency().getArtifact()).getGroupId() + ":" + dependencyArtifact.getArtifactId())) != null) {
                dependencies.add(dependencyPath);
            }
        });
        return dependencies;
    }

    private void serializeExportMap(File outputFile, Map<String, Set<String>> exportMap) throws IOException {
        DynamicAccessMetadataUtils.serialize((File)outputFile, exportMap);
        this.getLog().info((CharSequence)("Dynamic Access Metadata written into " + String.valueOf(outputFile)));
    }
}

