/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.buildtools.maven;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.graalvm.buildtools.agent.StandardAgentMode;
import org.graalvm.buildtools.maven.NativeExtension;
import org.graalvm.buildtools.maven.config.AbstractMergeAgentFilesMojo;
import org.graalvm.buildtools.maven.config.agent.AgentConfiguration;
import org.graalvm.buildtools.maven.config.agent.MetadataCopyConfiguration;

@Mojo(name="metadata-copy", defaultPhase=LifecyclePhase.NONE)
public class MetadataCopyMojo
extends AbstractMergeAgentFilesMojo {
    private static final String DEFAULT_OUTPUT_DIRECTORY = "/META-INF/native-image";
    private static final List<String> FILES_REQUIRED_FOR_MERGE_LEGACY = Arrays.asList("reflect-config.json", "jni-config.json", "proxy-config.json", "resource-config.json");
    private static final List<String> FILES_REQUIRED_FOR_MERGE = Arrays.asList("reachability-metadata.json");
    @Parameter(alias="agent")
    private AgentConfiguration agentConfiguration;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;

    public void execute() throws MojoExecutionException {
        if (this.agentConfiguration != null && (this.agentConfiguration.isEnabled() || this.agentIsEnabledFromCmd())) {
            if (this.agentConfiguration.getDefaultMode().equalsIgnoreCase("direct")) {
                this.logger.info("You are running agent in direct mode. Skipping both merge and metadata copy tasks.");
                this.logger.info("In direct mode, user takes full responsibility for agent configuration.");
                return;
            }
            MetadataCopyConfiguration config = this.agentConfiguration.getMetadataCopyConfiguration();
            if (config == null) {
                this.getLog().info((CharSequence)"Metadata copy config not provided. Skipping this task.");
                return;
            }
            String buildDirectory = this.project.getBuild().getDirectory() + "/native/agent-output/";
            String destinationDir = config.getOutputDirectory();
            if (destinationDir == null) {
                destinationDir = this.project.getBuild().getOutputDirectory().concat(DEFAULT_OUTPUT_DIRECTORY).concat("/").concat(this.project.getGroupId()).concat("/").concat(this.project.getArtifactId());
            }
            if (!Files.isDirectory(Paths.get(destinationDir, new String[0]), new LinkOption[0])) {
                this.logger.warn("Destination directory " + destinationDir + " doesn't exist.");
                this.logger.warn("Creating directory at: " + destinationDir);
                boolean success = new File(destinationDir).mkdirs();
                if (!success) {
                    throw new MojoExecutionException("Cannot create directory at the given location: " + destinationDir);
                }
            }
            this.executeCopy(buildDirectory, destinationDir);
            this.getLog().info((CharSequence)"Metadata copy process finished.");
        }
    }

    private void executeCopy(String buildDirectory, String destinationDir) throws MojoExecutionException {
        MetadataCopyConfiguration config = this.agentConfiguration.getMetadataCopyConfiguration();
        List<String> sourceDirectories = this.getSourceDirectories(config.getDisabledStages(), buildDirectory);
        if (sourceDirectories.isEmpty()) {
            this.logger.warn("Skipping metadata copy task. Both main and test stages are disabled in metadata copy configuration.");
            return;
        }
        if (config.shouldMerge() && !this.isDirectoryEmpty(destinationDir)) {
            if (!this.dirContainsFilesForMerge(destinationDir)) {
                List<String> destinationDirContent = Arrays.stream(Objects.requireNonNull(new File(destinationDir).listFiles())).map(File::getName).collect(Collectors.toList());
                List<String> missingFiles = this.getListDiff(FILES_REQUIRED_FOR_MERGE, destinationDirContent);
                throw new MojoExecutionException("There are missing files for merge in output directory. If you want to merge agent files with existing files in output directory, please make sure that output directory contains all of the following files: reflect-config.json, jni-config.json, proxy-config.json, resource-config.json, reachability-metadata.json. Currently the output directory is missing: " + String.valueOf(missingFiles));
            }
            sourceDirectories.add(destinationDir);
        }
        if (!this.checkIfSourcesExists(sourceDirectories)) {
            return;
        }
        String sourceDirsInfo = sourceDirectories.stream().map(File::new).map(File::getName).collect(Collectors.joining(", "));
        this.logger.info("Copying files from: " + sourceDirsInfo);
        List nativeImageConfigureOptions = new StandardAgentMode().getNativeImageConfigureOptions(sourceDirectories, Collections.singletonList(destinationDir));
        nativeImageConfigureOptions.add(0, this.getMergerExecutable().getAbsolutePath());
        ProcessBuilder processBuilder = new ProcessBuilder(nativeImageConfigureOptions);
        try {
            Process start = processBuilder.start();
            int retCode = start.waitFor();
            if (retCode != 0) {
                this.getLog().error((CharSequence)("Metadata copy process failed with code: " + retCode));
                throw new MojoExecutionException("Metadata copy process failed.");
            }
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean checkIfSourcesExists(List<String> sourceDirectories) {
        for (String source : sourceDirectories) {
            File dir = new File(source);
            if (dir.isDirectory() && dir.exists()) continue;
            this.logger.warn("Cannot find source directory " + source + " for metadata copy. Please check if you configured agent properly and it generates all necessary directories. If you want to skip copy from some source, please configure metadataCopy with disable stage you want to skip.");
            return false;
        }
        return true;
    }

    private List<String> getSourceDirectories(List<String> disabledStages, String buildDirectory) {
        ArrayList<String> sourceDirectories = new ArrayList<String>();
        sourceDirectories.add(buildDirectory + String.valueOf((Object)NativeExtension.Context.main));
        sourceDirectories.add(buildDirectory + String.valueOf((Object)NativeExtension.Context.test));
        for (String disabledStage : disabledStages) {
            sourceDirectories.remove(buildDirectory + disabledStage);
        }
        return sourceDirectories;
    }

    private boolean isDirectoryEmpty(String dirName) {
        File directory = new File(dirName);
        File[] content = directory.listFiles();
        return content == null || content.length == 0;
    }

    private boolean dirContainsFilesForMerge(String dir) {
        File baseDir = new File(dir);
        File[] content = baseDir.listFiles();
        if (content == null) {
            return false;
        }
        List<String> dirContent = Arrays.stream(content).map(File::getName).collect(Collectors.toList());
        return this.getListDiff(FILES_REQUIRED_FOR_MERGE, dirContent).isEmpty() || this.getListDiff(FILES_REQUIRED_FOR_MERGE_LEGACY, dirContent).isEmpty();
    }

    private List<String> getListDiff(List<String> list1, List<String> list2) {
        ArrayList<String> diff = new ArrayList<String>(list1);
        diff.removeAll(list2);
        return diff;
    }

    private boolean agentIsEnabledFromCmd() {
        if (this.session == null) {
            return false;
        }
        if (this.session.getSystemProperties().getProperty("agent") == null) {
            return false;
        }
        return this.session.getSystemProperties().getProperty("agent").equalsIgnoreCase("true");
    }
}

