/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.rs.client.util;

import java.util.StringTokenizer;

public class HttpWarning {
    private final int code;
    private final String application;
    private final String message;

    public static HttpWarning parse(String headerValue) {
        Integer code = null;
        String application = null;
        StringBuilder message = new StringBuilder();
        StringTokenizer tokens = new StringTokenizer(headerValue, " ");
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            if (code == null) {
                try {
                    code = Integer.parseInt(token);
                }
                catch (NumberFormatException e) {
                    code = -1;
                }
                continue;
            }
            if (application == null) {
                application = token;
                continue;
            }
            message.append(' ').append(token);
        }
        code = code == null ? new Integer(-1) : code;
        application = application == null ? "" : application;
        return new HttpWarning(code, application, message.toString());
    }

    public HttpWarning(int code, String application, String message) {
        this.code = code;
        this.application = application;
        this.message = message;
    }

    public int getCode() {
        return this.code;
    }

    public String getApplication() {
        return this.application;
    }

    public String getMessage() {
        return this.message;
    }
}

