/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.rs.client.util;

import java.util.ArrayList;
import java.util.List;
import org.gedcomx.Gedcomx;
import org.gedcomx.conclusion.Person;

public class DescendancyTree {
    private DescendancyNode root;

    public DescendancyTree(Gedcomx gx) {
        this.root = this.buildTree(gx);
    }

    protected DescendancyNode buildTree(Gedcomx gx) {
        DescendancyNode root = null;
        if (gx.getPersons() != null && gx.getPersons().size() > 0) {
            ArrayList<DescendancyNode> rootArray = new ArrayList<DescendancyNode>();
            for (Person person : gx.getPersons()) {
                int[] coordinates;
                boolean spouse;
                if (person.getDisplayExtension() == null || person.getDisplayExtension().getDescendancyNumber() == null) continue;
                String number = person.getDisplayExtension().getDescendancyNumber();
                boolean bl = spouse = number.endsWith("-S") || number.endsWith("-s");
                if (spouse) {
                    number = number.substring(0, number.length() - 2);
                }
                try {
                    coordinates = this.parseCoordinates(number);
                }
                catch (NumberFormatException e) {
                    continue;
                }
                List<DescendancyNode> current = rootArray;
                int i = 0;
                DescendancyNode node = null;
                while (current != null) {
                    int coordinate = coordinates[i];
                    while (current.size() < coordinate) {
                        current.add(null);
                    }
                    node = (DescendancyNode)current.get(coordinate - 1);
                    if (node == null) {
                        node = new DescendancyNode();
                        current.set(coordinate - 1, node);
                    }
                    if (++i < coordinates.length) {
                        List<DescendancyNode> children = node.getChildren();
                        if (children == null) {
                            children = new ArrayList<DescendancyNode>();
                            node.setChildren(children);
                        }
                        current = children;
                        continue;
                    }
                    current = null;
                }
                if (spouse) {
                    node.setSpouse(person);
                    continue;
                }
                node.setPerson(person);
            }
            if (rootArray.size() > 0) {
                root = (DescendancyNode)rootArray.get(0);
            }
        }
        return root;
    }

    public DescendancyNode getRoot() {
        return this.root;
    }

    protected int[] parseCoordinates(String number) throws NumberFormatException {
        ArrayList<StringBuilder> coords = new ArrayList<StringBuilder>();
        StringBuilder current = new StringBuilder();
        for (int i = 0; i < number.length(); ++i) {
            char ch = number.charAt(i);
            if (ch == '.') {
                coords.add(current);
                current = new StringBuilder();
                continue;
            }
            current.append(ch);
        }
        coords.add(current);
        int[] coordinates = new int[coords.size()];
        for (int i = 0; i < coords.size(); ++i) {
            StringBuilder num = (StringBuilder)coords.get(i);
            coordinates[i] = Integer.parseInt(num.toString());
        }
        return coordinates;
    }

    public class DescendancyNode {
        private Person person;
        private Person spouse;
        private List<DescendancyNode> children;

        public Person getPerson() {
            return this.person;
        }

        public void setPerson(Person person) {
            this.person = person;
        }

        public Person getSpouse() {
            return this.spouse;
        }

        public void setSpouse(Person spouse) {
            this.spouse = spouse;
        }

        public List<DescendancyNode> getChildren() {
            return this.children;
        }

        public void setChildren(List<DescendancyNode> children) {
            this.children = children;
        }
    }
}

