/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.rs.client.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class BaseSearchQueryBuilder {
    protected final List<SearchParameter> parameters = new ArrayList<SearchParameter>();

    public String build() {
        StringBuilder builder = new StringBuilder();
        Iterator<SearchParameter> it = this.parameters.iterator();
        while (it.hasNext()) {
            builder.append(it.next());
            if (!it.hasNext()) continue;
            builder.append(' ');
        }
        return builder.toString();
    }

    public static class SearchParameter {
        private final String prefix;
        private final String name;
        private final String value;
        private final boolean exact;

        public SearchParameter(String prefix, String name, String value, boolean exact) {
            if (name == null) {
                throw new NullPointerException("parameter name must not be null");
            }
            this.prefix = prefix;
            this.exact = exact;
            this.value = value;
            this.name = name;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public boolean isExact() {
            return this.exact;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            if (this.prefix != null) {
                builder.append(this.prefix);
            }
            builder.append(this.name);
            if (this.value != null) {
                boolean needsQuote;
                builder.append(':');
                String escaped = this.value.replace('\n', ' ').replace('\t', ' ').replace('\f', ' ').replace('\u000b', ' ').replace("\"", "\\\"");
                boolean bl = needsQuote = escaped.indexOf(32) != -1;
                if (needsQuote) {
                    builder.append('\"');
                }
                builder.append(escaped);
                if (needsQuote) {
                    builder.append('\"');
                }
                if (!this.exact) {
                    builder.append('~');
                }
            }
            return builder.toString();
        }
    }
}

