/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.rs.client;

import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import java.util.Arrays;
import org.gedcomx.Gedcomx;
import org.gedcomx.common.EvidenceReference;
import org.gedcomx.common.Note;
import org.gedcomx.common.ResourceReference;
import org.gedcomx.common.URI;
import org.gedcomx.conclusion.Conclusion;
import org.gedcomx.conclusion.Fact;
import org.gedcomx.conclusion.Relationship;
import org.gedcomx.links.Link;
import org.gedcomx.links.SupportsLinks;
import org.gedcomx.rs.client.CollectionState;
import org.gedcomx.rs.client.GedcomxApplicationException;
import org.gedcomx.rs.client.GedcomxApplicationState;
import org.gedcomx.rs.client.PersonState;
import org.gedcomx.rs.client.SourceDescriptionState;
import org.gedcomx.rs.client.StateFactory;
import org.gedcomx.rs.client.StateTransitionOption;
import org.gedcomx.source.SourceReference;

public class RelationshipState
extends GedcomxApplicationState<Gedcomx> {
    protected RelationshipState(ClientRequest request, ClientResponse response, String accessToken, StateFactory stateFactory) {
        super(request, response, accessToken, stateFactory);
    }

    @Override
    public String getSelfRel() {
        return "relationship";
    }

    @Override
    protected RelationshipState clone(ClientRequest request, ClientResponse response) {
        return new RelationshipState(request, response, this.accessToken, this.stateFactory);
    }

    @Override
    public RelationshipState ifSuccessful() {
        return (RelationshipState)super.ifSuccessful();
    }

    @Override
    public RelationshipState head(StateTransitionOption ... options) {
        return (RelationshipState)super.head(options);
    }

    @Override
    public RelationshipState options(StateTransitionOption ... options) {
        return (RelationshipState)super.options(options);
    }

    @Override
    public RelationshipState get(StateTransitionOption ... options) {
        return (RelationshipState)super.get(options);
    }

    @Override
    public RelationshipState delete(StateTransitionOption ... options) {
        return (RelationshipState)super.delete(options);
    }

    public RelationshipState put(Gedcomx e, StateTransitionOption ... options) {
        return (RelationshipState)super.put(e, options);
    }

    public RelationshipState post(Gedcomx entity, StateTransitionOption ... options) {
        return (RelationshipState)super.post(entity, options);
    }

    @Override
    public RelationshipState inject(ClientRequest request) {
        return (RelationshipState)super.inject(request);
    }

    @Override
    protected Gedcomx loadEntity(ClientResponse response) {
        return (Gedcomx)response.getEntity(Gedcomx.class);
    }

    @Override
    protected SupportsLinks getMainDataElement() {
        return this.getRelationship();
    }

    public Relationship getRelationship() {
        return this.getEntity() == null ? null : (((Gedcomx)this.getEntity()).getRelationships() == null ? null : (((Gedcomx)this.getEntity()).getRelationships().isEmpty() ? null : (Relationship)((Gedcomx)this.getEntity()).getRelationships().get(0)));
    }

    public Conclusion getConclusion() {
        return this.getFact() != null ? this.getFact() : null;
    }

    public Fact getFact() {
        Relationship relationship = this.getRelationship();
        return relationship == null ? null : (relationship.getFacts() == null ? null : (relationship.getFacts().isEmpty() ? null : (Fact)relationship.getFacts().get(0)));
    }

    public Note getNote() {
        Relationship relationship = this.getRelationship();
        return relationship == null ? null : (relationship.getNotes() == null ? null : (relationship.getNotes().isEmpty() ? null : (Note)relationship.getNotes().get(0)));
    }

    public SourceReference getSourceReference() {
        Relationship relationship = this.getRelationship();
        return relationship == null ? null : (relationship.getSources() == null ? null : (relationship.getSources().isEmpty() ? null : (SourceReference)relationship.getSources().get(0)));
    }

    public EvidenceReference getEvidenceReference() {
        Relationship relationship = this.getRelationship();
        return relationship == null ? null : (relationship.getEvidence() == null ? null : (relationship.getEvidence().isEmpty() ? null : (EvidenceReference)relationship.getEvidence().get(0)));
    }

    public SourceReference getMediaReference() {
        Relationship relationship = this.getRelationship();
        return relationship == null ? null : (relationship.getMedia() == null ? null : (relationship.getMedia().isEmpty() ? null : (SourceReference)relationship.getMedia().get(0)));
    }

    public CollectionState readCollection(StateTransitionOption ... options) {
        Link link = this.getLink("collection");
        if (link == null || link.getHref() == null) {
            return null;
        }
        ClientRequest request = this.createAuthenticatedGedcomxRequest().build(link.getHref().toURI(), "GET");
        return this.stateFactory.newCollectionState(request, this.invoke(request, options), this.accessToken);
    }

    public PersonState readPerson1(StateTransitionOption ... options) {
        Relationship relationship = this.getRelationship();
        if (relationship == null) {
            return null;
        }
        ResourceReference person1 = relationship.getPerson1();
        if (person1 == null || person1.getResource() == null) {
            return null;
        }
        ClientRequest request = this.createAuthenticatedGedcomxRequest().build(person1.getResource().toURI(), "GET");
        return this.stateFactory.newPersonState(request, this.invoke(request, options), this.accessToken);
    }

    public PersonState readPerson2(StateTransitionOption ... options) {
        Relationship relationship = this.getRelationship();
        if (relationship == null) {
            return null;
        }
        ResourceReference person2 = relationship.getPerson2();
        if (person2 == null || person2.getResource() == null) {
            return null;
        }
        ClientRequest request = this.createAuthenticatedGedcomxRequest().build(person2.getResource().toURI(), "GET");
        return this.stateFactory.newPersonState(request, this.invoke(request, options), this.accessToken);
    }

    public RelationshipState loadEmbeddedResources(StateTransitionOption ... options) {
        this.includeEmbeddedResources((Gedcomx)this.entity, new StateTransitionOption[0]);
        return this;
    }

    public RelationshipState loadEmbeddedResources(String[] rels, StateTransitionOption ... options) {
        for (String rel : rels) {
            Link link = this.getLink(rel);
            if (this.entity == null || link == null || link.getHref() == null) continue;
            this.embed(link, (Gedcomx)this.entity, options);
        }
        return this;
    }

    public RelationshipState loadConclusions(StateTransitionOption ... options) {
        return this.loadEmbeddedResources(new String[]{"conclusions"}, options);
    }

    public RelationshipState loadSourceReferences(StateTransitionOption ... options) {
        return this.loadEmbeddedResources(new String[]{"source-references"}, options);
    }

    public RelationshipState loadMediaReferences(StateTransitionOption ... options) {
        return this.loadEmbeddedResources(new String[]{"media-references"}, options);
    }

    public RelationshipState loadEvidenceReferences(StateTransitionOption ... options) {
        return this.loadEmbeddedResources(new String[]{"evidence-references"}, options);
    }

    public RelationshipState loadNotes(StateTransitionOption ... options) {
        return this.loadEmbeddedResources(new String[]{"notes"}, options);
    }

    protected Relationship createEmptySelf() {
        Relationship relationship = new Relationship();
        relationship.setId(this.getLocalSelfId());
        return relationship;
    }

    protected String getLocalSelfId() {
        Relationship me = this.getRelationship();
        return me == null ? null : me.getId();
    }

    public RelationshipState addFact(Fact fact, StateTransitionOption ... options) {
        return this.addFacts(new Fact[]{fact}, options);
    }

    public RelationshipState addFacts(Fact[] facts, StateTransitionOption ... options) {
        Relationship relationship = this.createEmptySelf();
        relationship.setFacts(Arrays.asList(facts));
        return this.updateConclusions(relationship, options);
    }

    public RelationshipState updateFact(Fact fact, StateTransitionOption ... options) {
        return this.updateFacts(new Fact[]{fact}, options);
    }

    public RelationshipState updateFacts(Fact[] facts, StateTransitionOption ... options) {
        Relationship relationship = this.createEmptySelf();
        relationship.setFacts(Arrays.asList(facts));
        return this.updateConclusions(relationship, options);
    }

    protected RelationshipState updateConclusions(Relationship relationship, StateTransitionOption ... options) {
        java.net.URI target = this.getSelfUri();
        Link conclusionsLink = this.getLink("conclusions");
        if (conclusionsLink != null && conclusionsLink.getHref() != null) {
            target = conclusionsLink.getHref().toURI();
        }
        Gedcomx gx = new Gedcomx();
        gx.setRelationships(Arrays.asList(relationship));
        ClientRequest request = ((ClientRequest.Builder)this.createAuthenticatedGedcomxRequest().entity((Object)gx)).build(target, "POST");
        return this.stateFactory.newRelationshipState(request, this.invoke(request, options), this.accessToken);
    }

    public RelationshipState deleteFact(Fact fact, StateTransitionOption ... options) {
        Link link = fact.getLink("conclusion");
        Link link2 = link = link == null ? fact.getLink("self") : link;
        if (link == null || link.getHref() == null) {
            throw new GedcomxApplicationException("Conclusion cannot be deleted: missing link.");
        }
        ClientRequest request = this.createAuthenticatedGedcomxRequest().build(link.getHref().toURI(), "DELETE");
        return this.stateFactory.newRelationshipState(request, this.invoke(request, options), this.accessToken);
    }

    public RelationshipState addSourceReference(SourceDescriptionState source, StateTransitionOption ... options) {
        SourceReference reference = new SourceReference();
        reference.setDescriptionRef(new URI(source.getSelfUri().toString()));
        return this.addSourceReference(reference, options);
    }

    public RelationshipState addSourceReference(SourceReference reference, StateTransitionOption ... options) {
        return this.addSourceReferences(new SourceReference[]{reference}, options);
    }

    public RelationshipState addSourceReferences(SourceReference[] refs, StateTransitionOption ... options) {
        Relationship relationship = this.createEmptySelf();
        relationship.setSources(Arrays.asList(refs));
        return this.updateSourceReferences(relationship, options);
    }

    public RelationshipState updateSourceReference(SourceReference reference, StateTransitionOption ... options) {
        return this.updateSourceReferences(new SourceReference[]{reference}, options);
    }

    public RelationshipState updateSourceReferences(SourceReference[] refs, StateTransitionOption ... options) {
        Relationship relationship = this.createEmptySelf();
        relationship.setSources(Arrays.asList(refs));
        return this.updateSourceReferences(relationship, options);
    }

    protected RelationshipState updateSourceReferences(Relationship relationship, StateTransitionOption ... options) {
        java.net.URI target = this.getSelfUri();
        Link conclusionsLink = this.getLink("source-references");
        if (conclusionsLink != null && conclusionsLink.getHref() != null) {
            target = conclusionsLink.getHref().toURI();
        }
        Gedcomx gx = new Gedcomx();
        gx.setRelationships(Arrays.asList(relationship));
        ClientRequest request = ((ClientRequest.Builder)this.createAuthenticatedGedcomxRequest().entity((Object)gx)).build(target, "POST");
        return this.stateFactory.newRelationshipState(request, this.invoke(request, options), this.accessToken);
    }

    public RelationshipState deleteSourceReference(SourceReference reference, StateTransitionOption ... options) {
        Link link = reference.getLink("source-reference");
        Link link2 = link = link == null ? reference.getLink("self") : link;
        if (link == null || link.getHref() == null) {
            throw new GedcomxApplicationException("Source reference cannot be deleted: missing link.");
        }
        ClientRequest request = this.createAuthenticatedGedcomxRequest().build(link.getHref().toURI(), "DELETE");
        return this.stateFactory.newRelationshipState(request, this.invoke(request, options), this.accessToken);
    }

    public SourceDescriptionState readSourceDescription(SourceReference sourceReference, StateTransitionOption ... options) {
        Link link = sourceReference.getLink("description");
        Link link2 = link = link == null ? sourceReference.getLink("self") : link;
        if (link == null || link.getHref() == null) {
            throw new GedcomxApplicationException("Source description cannot be read: missing link.");
        }
        ClientRequest request = this.createAuthenticatedGedcomxRequest().build(link.getHref().toURI(), "GET");
        return this.stateFactory.newSourceDescriptionState(request, this.invoke(request, options), this.accessToken);
    }

    public RelationshipState addMediaReference(SourceDescriptionState description, StateTransitionOption ... options) {
        SourceReference reference = new SourceReference();
        reference.setDescriptionRef(new URI(description.getSelfUri().toString()));
        return this.addMediaReference(reference, options);
    }

    public RelationshipState addMediaReference(SourceReference reference, StateTransitionOption ... options) {
        return this.addMediaReferences(new SourceReference[]{reference}, options);
    }

    public RelationshipState addMediaReferences(SourceReference[] refs, StateTransitionOption ... options) {
        Relationship relationship = this.createEmptySelf();
        relationship.setMedia(Arrays.asList(refs));
        return this.updateMediaReferences(relationship, options);
    }

    public RelationshipState updateMediaReference(SourceReference reference, StateTransitionOption ... options) {
        return this.updateMediaReferences(new SourceReference[]{reference}, options);
    }

    public RelationshipState updateMediaReferences(SourceReference[] refs, StateTransitionOption ... options) {
        Relationship relationship = this.createEmptySelf();
        relationship.setMedia(Arrays.asList(refs));
        return this.updateMediaReferences(relationship, options);
    }

    protected RelationshipState updateMediaReferences(Relationship relationship, StateTransitionOption ... options) {
        java.net.URI target = this.getSelfUri();
        Link conclusionsLink = this.getLink("media-references");
        if (conclusionsLink != null && conclusionsLink.getHref() != null) {
            target = conclusionsLink.getHref().toURI();
        }
        Gedcomx gx = new Gedcomx();
        gx.setRelationships(Arrays.asList(relationship));
        ClientRequest request = ((ClientRequest.Builder)this.createAuthenticatedGedcomxRequest().entity((Object)gx)).build(target, "POST");
        return this.stateFactory.newRelationshipState(request, this.invoke(request, options), this.accessToken);
    }

    public RelationshipState deleteMediaReference(SourceReference reference, StateTransitionOption ... options) {
        Link link = reference.getLink("media-reference");
        Link link2 = link = link == null ? reference.getLink("self") : link;
        if (link == null || link.getHref() == null) {
            throw new GedcomxApplicationException("Media reference cannot be deleted: missing link.");
        }
        ClientRequest request = this.createAuthenticatedGedcomxRequest().build(link.getHref().toURI(), "DELETE");
        return this.stateFactory.newRelationshipState(request, this.invoke(request, options), this.accessToken);
    }

    public RelationshipState addEvidenceReference(RelationshipState evidence, StateTransitionOption ... options) {
        EvidenceReference reference = new EvidenceReference();
        reference.setResource(new URI(evidence.getSelfUri().toString()));
        return this.addEvidenceReference(reference, options);
    }

    public RelationshipState addEvidenceReference(EvidenceReference reference, StateTransitionOption ... options) {
        return this.addEvidenceReferences(new EvidenceReference[]{reference}, options);
    }

    public RelationshipState addEvidenceReferences(EvidenceReference[] refs, StateTransitionOption ... options) {
        Relationship relationship = this.createEmptySelf();
        relationship.setEvidence(Arrays.asList(refs));
        return this.updateEvidenceReferences(relationship, options);
    }

    public RelationshipState updateEvidenceReference(EvidenceReference reference, StateTransitionOption ... options) {
        return this.updateEvidenceReferences(new EvidenceReference[]{reference}, options);
    }

    public RelationshipState updateEvidenceReferences(EvidenceReference[] refs, StateTransitionOption ... options) {
        Relationship relationship = this.createEmptySelf();
        relationship.setEvidence(Arrays.asList(refs));
        return this.updateEvidenceReferences(relationship, options);
    }

    protected RelationshipState updateEvidenceReferences(Relationship relationship, StateTransitionOption ... options) {
        java.net.URI target = this.getSelfUri();
        Link conclusionsLink = this.getLink("evidence-references");
        if (conclusionsLink != null && conclusionsLink.getHref() != null) {
            target = conclusionsLink.getHref().toURI();
        }
        Gedcomx gx = new Gedcomx();
        gx.setRelationships(Arrays.asList(relationship));
        ClientRequest request = ((ClientRequest.Builder)this.createAuthenticatedGedcomxRequest().entity((Object)gx)).build(target, "POST");
        return this.stateFactory.newRelationshipState(request, this.invoke(request, options), this.accessToken);
    }

    public RelationshipState deleteEvidenceReference(EvidenceReference reference, StateTransitionOption ... options) {
        Link link = reference.getLink("evidence-reference");
        Link link2 = link = link == null ? reference.getLink("self") : link;
        if (link == null || link.getHref() == null) {
            throw new GedcomxApplicationException("Evidence reference cannot be deleted: missing link.");
        }
        ClientRequest request = this.createAuthenticatedGedcomxRequest().build(link.getHref().toURI(), "DELETE");
        return this.stateFactory.newRelationshipState(request, this.invoke(request, options), this.accessToken);
    }

    public RelationshipState readNote(Note note, StateTransitionOption ... options) {
        Link link = note.getLink("note");
        Link link2 = link = link == null ? note.getLink("self") : link;
        if (link == null || link.getHref() == null) {
            throw new GedcomxApplicationException("Note cannot be read: missing link.");
        }
        ClientRequest request = this.createAuthenticatedGedcomxRequest().build(link.getHref().toURI(), "GET");
        return this.stateFactory.newRelationshipState(request, this.invoke(request, options), this.accessToken);
    }

    public RelationshipState addNote(Note note, StateTransitionOption ... options) {
        return this.addNotes(new Note[]{note}, options);
    }

    public RelationshipState addNotes(Note[] notes, StateTransitionOption ... options) {
        Relationship relationship = this.createEmptySelf();
        relationship.setNotes(Arrays.asList(notes));
        return this.updateNotes(relationship, options);
    }

    public RelationshipState updateNote(Note note, StateTransitionOption ... options) {
        return this.updateNotes(new Note[]{note}, options);
    }

    public RelationshipState updateNotes(Note[] notes, StateTransitionOption ... options) {
        Relationship relationship = this.createEmptySelf();
        relationship.setNotes(Arrays.asList(notes));
        return this.updateNotes(relationship, options);
    }

    protected RelationshipState updateNotes(Relationship relationship, StateTransitionOption ... options) {
        java.net.URI target = this.getSelfUri();
        Link conclusionsLink = this.getLink("notes");
        if (conclusionsLink != null && conclusionsLink.getHref() != null) {
            target = conclusionsLink.getHref().toURI();
        }
        Gedcomx gx = new Gedcomx();
        gx.setRelationships(Arrays.asList(relationship));
        ClientRequest request = ((ClientRequest.Builder)this.createAuthenticatedGedcomxRequest().entity((Object)gx)).build(target, "POST");
        return this.stateFactory.newRelationshipState(request, this.invoke(request, options), this.accessToken);
    }

    public RelationshipState deleteNote(Note note, StateTransitionOption ... options) {
        Link link = note.getLink("note");
        Link link2 = link = link == null ? note.getLink("self") : link;
        if (link == null || link.getHref() == null) {
            throw new GedcomxApplicationException("Note cannot be deleted: missing link.");
        }
        ClientRequest request = this.createAuthenticatedGedcomxRequest().build(link.getHref().toURI(), "DELETE");
        return this.stateFactory.newRelationshipState(request, this.invoke(request, options), this.accessToken);
    }
}

