/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.rs.client;

import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import java.util.List;
import org.gedcomx.Gedcomx;
import org.gedcomx.common.ResourceReference;
import org.gedcomx.conclusion.Person;
import org.gedcomx.conclusion.Relationship;
import org.gedcomx.links.Link;
import org.gedcomx.links.SupportsLinks;
import org.gedcomx.rs.client.GedcomxApplicationException;
import org.gedcomx.rs.client.GedcomxApplicationState;
import org.gedcomx.rs.client.PersonState;
import org.gedcomx.rs.client.RelationshipState;
import org.gedcomx.rs.client.StateFactory;
import org.gedcomx.rs.client.StateTransitionOption;

public class PersonSpousesState
extends GedcomxApplicationState<Gedcomx> {
    protected PersonSpousesState(ClientRequest request, ClientResponse response, String accessToken, StateFactory stateFactory) {
        super(request, response, accessToken, stateFactory);
    }

    @Override
    protected PersonSpousesState clone(ClientRequest request, ClientResponse response) {
        return new PersonSpousesState(request, response, this.accessToken, this.stateFactory);
    }

    @Override
    public PersonSpousesState ifSuccessful() {
        return (PersonSpousesState)super.ifSuccessful();
    }

    @Override
    public PersonSpousesState head(StateTransitionOption ... options) {
        return (PersonSpousesState)super.head(options);
    }

    @Override
    public PersonSpousesState options(StateTransitionOption ... options) {
        return (PersonSpousesState)super.options(options);
    }

    @Override
    public PersonSpousesState get(StateTransitionOption ... options) {
        return (PersonSpousesState)super.get(options);
    }

    @Override
    public PersonSpousesState delete(StateTransitionOption ... options) {
        return (PersonSpousesState)super.delete(options);
    }

    public PersonSpousesState put(Gedcomx e, StateTransitionOption ... options) {
        return (PersonSpousesState)super.put(e, options);
    }

    public PersonSpousesState post(Gedcomx entity, StateTransitionOption ... options) {
        return (PersonSpousesState)super.post(entity, options);
    }

    @Override
    protected Gedcomx loadEntity(ClientResponse response) {
        return (Gedcomx)response.getEntity(Gedcomx.class);
    }

    @Override
    protected SupportsLinks getMainDataElement() {
        return (SupportsLinks)this.getEntity();
    }

    public List<Person> getPersons() {
        return this.entity == null ? null : ((Gedcomx)this.entity).getPersons();
    }

    public List<Relationship> getRelationships() {
        return this.entity == null ? null : ((Gedcomx)this.entity).getRelationships();
    }

    public Relationship findRelationshipTo(Person spouse) {
        List<Relationship> relationships = this.getRelationships();
        if (relationships != null) {
            for (Relationship relationship : relationships) {
                String reference;
                ResourceReference personReference = relationship.getPerson1();
                if (personReference != null && (reference = personReference.getResource().toString()).equals("#" + spouse.getId())) {
                    return relationship;
                }
                personReference = relationship.getPerson2();
                if (personReference == null || !(reference = personReference.getResource().toString()).equals("#" + spouse.getId())) continue;
                return relationship;
            }
        }
        return null;
    }

    public PersonState readPerson(StateTransitionOption ... options) {
        Link link = this.getLink("person");
        if (link == null || link.getHref() == null) {
            return null;
        }
        ClientRequest request = this.createAuthenticatedGedcomxRequest().build(link.getHref().toURI(), "GET");
        return this.stateFactory.newPersonState(request, this.invoke(request, options), this.accessToken);
    }

    public PersonState readSpouse(Person person, StateTransitionOption ... options) {
        Link link = person.getLink("person");
        Link link2 = link = link == null ? person.getLink("self") : link;
        if (link == null || link.getHref() == null) {
            return null;
        }
        ClientRequest request = this.createAuthenticatedGedcomxRequest().build(link.getHref().toURI(), "GET");
        return this.stateFactory.newPersonState(request, this.invoke(request, options), this.accessToken);
    }

    public PersonState readAncestryWithSpouse(Person person, StateTransitionOption ... options) {
        Link link = person.getLink("ancestry");
        if (link == null || link.getHref() == null) {
            return null;
        }
        ClientRequest request = this.createAuthenticatedGedcomxRequest().build(link.getHref().toURI(), "GET");
        return this.stateFactory.newPersonState(request, this.invoke(request, options), this.accessToken);
    }

    public PersonState readDescendancyWithSpouse(Person person, StateTransitionOption ... options) {
        Link link = person.getLink("descendancy");
        if (link == null || link.getHref() == null) {
            return null;
        }
        ClientRequest request = this.createAuthenticatedGedcomxRequest().build(link.getHref().toURI(), "GET");
        return this.stateFactory.newPersonState(request, this.invoke(request, options), this.accessToken);
    }

    public RelationshipState readRelationship(Relationship relationship, StateTransitionOption ... options) {
        Link link = relationship.getLink("relationship");
        Link link2 = link = link == null ? relationship.getLink("self") : link;
        if (link == null || link.getHref() == null) {
            return null;
        }
        ClientRequest request = this.createAuthenticatedGedcomxRequest().build(link.getHref().toURI(), "GET");
        return this.stateFactory.newRelationshipState(request, this.invoke(request, options), this.accessToken);
    }

    public RelationshipState removeRelationship(Relationship relationship, StateTransitionOption ... options) {
        Link link = relationship.getLink("relationship");
        Link link2 = link = link == null ? relationship.getLink("self") : link;
        if (link == null || link.getHref() == null) {
            throw new GedcomxApplicationException("Unable to remove relationship: missing link.");
        }
        ClientRequest request = this.createAuthenticatedGedcomxRequest().build(link.getHref().toURI(), "DELETE");
        return this.stateFactory.newRelationshipState(request, this.invoke(request, options), this.accessToken);
    }

    public RelationshipState removeRelationshipTo(Person spouse, StateTransitionOption ... options) {
        Relationship relationship = this.findRelationshipTo(spouse);
        if (relationship == null) {
            throw new GedcomxApplicationException("Unable to remove relationship: not found.");
        }
        Link link = relationship.getLink("relationship");
        Link link2 = link = link == null ? relationship.getLink("self") : link;
        if (link == null || link.getHref() == null) {
            throw new GedcomxApplicationException("Unable to remove relationship: missing link.");
        }
        ClientRequest request = this.createAuthenticatedGedcomxRequest().build(link.getHref().toURI(), "DELETE");
        return this.stateFactory.newRelationshipState(request, this.invoke(request, options), this.accessToken);
    }
}

