/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.join.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.search.DocValuesFieldExistsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.plain.DocValuesIndexFieldData;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.StringFieldType;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.join.mapper.MetaJoinFieldMapper;
import org.elasticsearch.join.mapper.ParentIdFieldMapper;

public final class ParentJoinFieldMapper
extends FieldMapper {
    public static final String NAME = "join";
    public static final String CONTENT_TYPE = "join";
    private MetaJoinFieldMapper uniqueFieldMapper;
    private List<ParentIdFieldMapper> parentIdFields;
    private boolean eagerGlobalOrdinals;

    public static ParentJoinFieldMapper getMapper(MapperService service) {
        MetaJoinFieldMapper.MetaJoinFieldType fieldType = (MetaJoinFieldMapper.MetaJoinFieldType)service.fullName("_parent_join");
        return fieldType == null ? null : fieldType.getMapper();
    }

    private static String getParentIdFieldName(String joinFieldName, String parentName) {
        return joinFieldName + "#" + parentName;
    }

    private static void checkIndexCompatibility(IndexSettings settings, String name) {
        if (settings.getIndexMetaData().isRoutingPartitionedIndex()) {
            throw new IllegalStateException("cannot create join field [" + name + "] for the partitioned index [" + settings.getIndex().getName() + "]");
        }
    }

    private static void checkObjectOrNested(ContentPath path, String name) {
        if (path.pathAsText(name).contains(".")) {
            throw new IllegalArgumentException("join field [" + path.pathAsText(name) + "] cannot be added inside an object or in a multi-field");
        }
    }

    private static void checkParentFields(String name, List<ParentIdFieldMapper> mappers) {
        HashSet<String> children = new HashSet<String>();
        ArrayList<String> conflicts = new ArrayList<String>();
        for (ParentIdFieldMapper mapper : mappers) {
            for (String child : mapper.getChildren()) {
                if (children.add(child)) continue;
                conflicts.add("[" + child + "] cannot have multiple parents");
            }
        }
        if (!conflicts.isEmpty()) {
            throw new IllegalArgumentException("invalid definition for join field [" + name + "]:\n" + ((Object)conflicts).toString());
        }
    }

    protected ParentJoinFieldMapper(String simpleName, MappedFieldType fieldType, Settings indexSettings, MetaJoinFieldMapper uniqueFieldMapper, List<ParentIdFieldMapper> parentIdFields, boolean eagerGlobalOrdinals) {
        super(simpleName, fieldType, Defaults.FIELD_TYPE, indexSettings, FieldMapper.MultiFields.empty(), FieldMapper.CopyTo.empty());
        this.parentIdFields = parentIdFields;
        this.uniqueFieldMapper = uniqueFieldMapper;
        this.uniqueFieldMapper.setFieldMapper(this);
        this.eagerGlobalOrdinals = eagerGlobalOrdinals;
    }

    protected String contentType() {
        return "join";
    }

    protected ParentJoinFieldMapper clone() {
        return (ParentJoinFieldMapper)super.clone();
    }

    public JoinFieldType fieldType() {
        return (JoinFieldType)super.fieldType();
    }

    public Iterator<Mapper> iterator() {
        ArrayList<ParentIdFieldMapper> mappers = new ArrayList<ParentIdFieldMapper>(this.parentIdFields);
        mappers.add((ParentIdFieldMapper)((Object)this.uniqueFieldMapper));
        return mappers.iterator();
    }

    public boolean hasParent(String name) {
        return this.parentIdFields.stream().anyMatch(mapper -> name.equals(mapper.getParentName()));
    }

    public boolean hasChild(String name) {
        return this.parentIdFields.stream().anyMatch(mapper -> mapper.getChildren().contains(name));
    }

    public ParentIdFieldMapper getParentIdFieldMapper(String name, boolean isParent) {
        for (ParentIdFieldMapper mapper : this.parentIdFields) {
            if (isParent && name.equals(mapper.getParentName())) {
                return mapper;
            }
            if (isParent || !mapper.getChildren().contains(name)) continue;
            return mapper;
        }
        return null;
    }

    protected void doMerge(Mapper mergeWith) {
        super.doMerge(mergeWith);
        ParentJoinFieldMapper joinMergeWith = (ParentJoinFieldMapper)mergeWith;
        ArrayList<String> conflicts = new ArrayList<String>();
        for (ParentIdFieldMapper mapper : this.parentIdFields) {
            if (joinMergeWith.getParentIdFieldMapper(mapper.getParentName(), true) != null) continue;
            conflicts.add("cannot remove parent [" + mapper.getParentName() + "] in join field [" + this.name() + "]");
        }
        ArrayList<ParentIdFieldMapper> newParentIdFields = new ArrayList<ParentIdFieldMapper>();
        for (ParentIdFieldMapper mergeWithMapper : joinMergeWith.parentIdFields) {
            ParentIdFieldMapper self = this.getParentIdFieldMapper(mergeWithMapper.getParentName(), true);
            if (self == null) {
                if (this.getParentIdFieldMapper(mergeWithMapper.getParentName(), false) != null) {
                    conflicts.add("cannot create parent [" + mergeWithMapper.getParentName() + "] from an existing child");
                }
                for (String child : mergeWithMapper.getChildren()) {
                    if (this.getParentIdFieldMapper(child, true) == null) continue;
                    conflicts.add("cannot create child [" + child + "] from an existing parent");
                }
                newParentIdFields.add(mergeWithMapper);
                continue;
            }
            for (String child : self.getChildren()) {
                if (mergeWithMapper.getChildren().contains(child)) continue;
                conflicts.add("cannot remove child [" + child + "] in join field [" + this.name() + "]");
            }
            ParentIdFieldMapper merged = (ParentIdFieldMapper)self.merge((Mapper)mergeWithMapper);
            newParentIdFields.add(merged);
        }
        if (!conflicts.isEmpty()) {
            throw new IllegalStateException("invalid update for join field [" + this.name() + "]:\n" + ((Object)conflicts).toString());
        }
        this.eagerGlobalOrdinals = joinMergeWith.eagerGlobalOrdinals;
        this.parentIdFields = Collections.unmodifiableList(newParentIdFields);
        this.uniqueFieldMapper = (MetaJoinFieldMapper)this.uniqueFieldMapper.merge((Mapper)joinMergeWith.uniqueFieldMapper);
        this.uniqueFieldMapper.setFieldMapper(this);
    }

    public FieldMapper updateFieldType(Map<String, MappedFieldType> fullNameToFieldType) {
        ParentJoinFieldMapper fieldMapper = (ParentJoinFieldMapper)super.updateFieldType(fullNameToFieldType);
        ArrayList<ParentIdFieldMapper> newMappers = new ArrayList<ParentIdFieldMapper>();
        for (ParentIdFieldMapper mapper : fieldMapper.parentIdFields) {
            newMappers.add((ParentIdFieldMapper)mapper.updateFieldType(fullNameToFieldType));
        }
        fieldMapper.parentIdFields = Collections.unmodifiableList(newMappers);
        this.uniqueFieldMapper = (MetaJoinFieldMapper)this.uniqueFieldMapper.updateFieldType(fullNameToFieldType);
        this.uniqueFieldMapper.setFieldMapper(this);
        return fieldMapper;
    }

    protected void parseCreateField(ParseContext context, List<IndexableField> fields) throws IOException {
        throw new UnsupportedOperationException("parsing is implemented in parse(), this method should NEVER be called");
    }

    public void parse(ParseContext context) throws IOException {
        ParseContext externalContext;
        context.path().add(this.simpleName());
        XContentParser.Token token = context.parser().currentToken();
        String name = null;
        String parent = null;
        if (token == XContentParser.Token.START_OBJECT) {
            String currentFieldName = null;
            while ((token = context.parser().nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = context.parser().currentName();
                    continue;
                }
                if (token == XContentParser.Token.VALUE_STRING) {
                    if ("name".equals(currentFieldName)) {
                        name = context.parser().text();
                        continue;
                    }
                    if ("parent".equals(currentFieldName)) {
                        parent = context.parser().text();
                        continue;
                    }
                    throw new IllegalArgumentException("unknown field name [" + currentFieldName + "] in join field [" + this.name() + "]");
                }
                if (token != XContentParser.Token.VALUE_NUMBER) continue;
                if ("parent".equals(currentFieldName)) {
                    parent = context.parser().numberValue().toString();
                    continue;
                }
                throw new IllegalArgumentException("unknown field name [" + currentFieldName + "] in join field [" + this.name() + "]");
            }
        } else if (token == XContentParser.Token.VALUE_STRING) {
            name = context.parser().text();
            parent = null;
        } else {
            throw new IllegalStateException("[" + name + "] expected START_OBJECT or VALUE_STRING but was: " + token);
        }
        ParentIdFieldMapper parentIdField = this.getParentIdFieldMapper(name, true);
        ParentIdFieldMapper childParentIdField = this.getParentIdFieldMapper(name, false);
        if (parentIdField == null && childParentIdField == null) {
            throw new IllegalArgumentException("unknown join name [" + name + "] for field [" + this.name() + "]");
        }
        if (childParentIdField != null) {
            if (parent == null) {
                throw new IllegalArgumentException("[parent] is missing for join field [" + this.name() + "]");
            }
            if (context.sourceToParse().routing() == null) {
                throw new IllegalArgumentException("[routing] is missing for join field [" + this.name() + "]");
            }
            assert (childParentIdField.getChildren().contains(name));
            externalContext = context.createExternalValueContext((Object)parent);
            childParentIdField.parse(externalContext);
        }
        if (parentIdField != null) {
            assert (parentIdField.getParentName().equals(name));
            externalContext = context.createExternalValueContext((Object)context.sourceToParse().id());
            parentIdField.parse(externalContext);
        }
        BytesRef binaryValue = new BytesRef((CharSequence)name);
        Field field = new Field(this.fieldType().name(), binaryValue, (IndexableFieldType)this.fieldType());
        context.doc().add((IndexableField)field);
        context.doc().add((IndexableField)new SortedDocValuesField(this.fieldType().name(), binaryValue));
        context.path().remove();
    }

    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        builder.field("type", this.contentType());
        builder.field("eager_global_ordinals", this.eagerGlobalOrdinals);
        builder.startObject("relations");
        for (ParentIdFieldMapper field : this.parentIdFields) {
            if (field.getChildren().size() == 1) {
                builder.field(field.getParentName(), field.getChildren().iterator().next());
                continue;
            }
            builder.field(field.getParentName(), field.getChildren());
        }
        builder.endObject();
    }

    public static class Defaults {
        public static final MappedFieldType FIELD_TYPE = new JoinFieldType();

        static {
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.setHasDocValues(true);
            FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
            FIELD_TYPE.freeze();
        }
    }

    public static final class JoinFieldType
    extends StringFieldType {
        public JoinFieldType() {
            this.setIndexAnalyzer(Lucene.KEYWORD_ANALYZER);
            this.setSearchAnalyzer(Lucene.KEYWORD_ANALYZER);
        }

        protected JoinFieldType(JoinFieldType ref) {
            super((MappedFieldType)ref);
        }

        public JoinFieldType clone() {
            return new JoinFieldType(this);
        }

        public String typeName() {
            return "join";
        }

        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName) {
            this.failIfNoDocValues();
            return new DocValuesIndexFieldData.Builder();
        }

        public Object valueForDisplay(Object value) {
            if (value == null) {
                return null;
            }
            BytesRef binaryValue = (BytesRef)value;
            return binaryValue.utf8ToString();
        }

        public Query existsQuery(QueryShardContext context) {
            return new DocValuesFieldExistsQuery(this.name());
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        public Mapper.Builder<?, ?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            IndexSettings indexSettings = parserContext.mapperService().getIndexSettings();
            ParentJoinFieldMapper.checkIndexCompatibility(indexSettings, name);
            Builder builder = new Builder(name);
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                if ("type".equals(entry.getKey())) continue;
                if ("eager_global_ordinals".equals(entry.getKey())) {
                    builder.eagerGlobalOrdinals(XContentMapValues.nodeBooleanValue((Object)entry.getValue(), (String)"eager_global_ordinals"));
                    iterator.remove();
                    continue;
                }
                if (!"relations".equals(entry.getKey())) continue;
                Map relations = XContentMapValues.nodeMapValue((Object)entry.getValue(), (String)"relations");
                for (Map.Entry relation : relations.entrySet()) {
                    String parent = (String)relation.getKey();
                    Set<String> children = XContentMapValues.isArray(relation.getValue()) ? new HashSet<String>(Arrays.asList(XContentMapValues.nodeStringArrayValue(relation.getValue()))) : Collections.singleton(relation.getValue().toString());
                    builder.addParent(parent, children);
                }
                iterator.remove();
            }
            return builder;
        }
    }

    public static class Builder
    extends FieldMapper.Builder<Builder, ParentJoinFieldMapper> {
        final List<ParentIdFieldMapper.Builder> parentIdFieldBuilders = new ArrayList<ParentIdFieldMapper.Builder>();
        boolean eagerGlobalOrdinals = true;

        public Builder(String name) {
            super(name, Defaults.FIELD_TYPE, Defaults.FIELD_TYPE);
            this.builder = this;
        }

        public JoinFieldType fieldType() {
            return (JoinFieldType)super.fieldType();
        }

        public Builder addParent(String parent, Set<String> children) {
            String parentIdFieldName = ParentJoinFieldMapper.getParentIdFieldName(this.name, parent);
            this.parentIdFieldBuilders.add(new ParentIdFieldMapper.Builder(parentIdFieldName, parent, children));
            return (Builder)this.builder;
        }

        public Builder eagerGlobalOrdinals(boolean eagerGlobalOrdinals) {
            this.eagerGlobalOrdinals = eagerGlobalOrdinals;
            return (Builder)this.builder;
        }

        public ParentJoinFieldMapper build(Mapper.BuilderContext context) {
            ParentJoinFieldMapper.checkObjectOrNested(context.path(), this.name);
            this.fieldType.setName(this.name);
            ArrayList parentIdFields = new ArrayList();
            this.parentIdFieldBuilders.stream().map(parentBuilder -> {
                if (this.eagerGlobalOrdinals) {
                    parentBuilder.eagerGlobalOrdinals(true);
                }
                return parentBuilder.build(context);
            }).forEach(parentIdFields::add);
            ParentJoinFieldMapper.checkParentFields(this.name(), parentIdFields);
            MetaJoinFieldMapper unique = new MetaJoinFieldMapper.Builder().build(context);
            return new ParentJoinFieldMapper(this.name, this.fieldType, context.indexSettings(), unique, Collections.unmodifiableList(parentIdFields), this.eagerGlobalOrdinals);
        }
    }
}

