/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common;

import java.net.InetSocketAddress;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.ThreadClassLoaderScope;
import org.eclipse.jetty.websocket.api.BatchMode;
import org.eclipse.jetty.websocket.api.CloseStatus;
import org.eclipse.jetty.websocket.api.RemoteEndpoint;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.SuspendToken;
import org.eclipse.jetty.websocket.api.UpgradeRequest;
import org.eclipse.jetty.websocket.api.UpgradeResponse;
import org.eclipse.jetty.websocket.api.WebSocketException;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.api.WriteCallback;
import org.eclipse.jetty.websocket.api.extensions.ExtensionFactory;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.api.extensions.IncomingFrames;
import org.eclipse.jetty.websocket.api.extensions.OutgoingFrames;
import org.eclipse.jetty.websocket.common.CloseInfo;
import org.eclipse.jetty.websocket.common.LogicalConnection;
import org.eclipse.jetty.websocket.common.RemoteEndpointFactory;
import org.eclipse.jetty.websocket.common.WebSocketRemoteEndpoint;
import org.eclipse.jetty.websocket.common.WebSocketSessionListener;
import org.eclipse.jetty.websocket.common.events.EventDriver;
import org.eclipse.jetty.websocket.common.io.DisconnectCallback;
import org.eclipse.jetty.websocket.common.scopes.WebSocketContainerScope;
import org.eclipse.jetty.websocket.common.scopes.WebSocketSessionScope;

@ManagedObject(value="A Jetty WebSocket Session")
public class WebSocketSession
extends ContainerLifeCycle
implements Session,
RemoteEndpointFactory,
WebSocketSessionScope,
IncomingFrames,
OutgoingFrames,
Connection.Listener {
    private static final Logger LOG = Log.getLogger(WebSocketSession.class);
    private final WebSocketContainerScope containerScope;
    private final URI requestURI;
    private final LogicalConnection connection;
    private final EventDriver websocket;
    private final Executor executor;
    private final WebSocketPolicy policy;
    private final AtomicBoolean onCloseCalled = new AtomicBoolean(false);
    private ClassLoader classLoader;
    private ExtensionFactory extensionFactory;
    private RemoteEndpointFactory remoteEndpointFactory;
    private String protocolVersion;
    private Map<String, String[]> parameterMap = new HashMap<String, String[]>();
    private RemoteEndpoint remote;
    private IncomingFrames incomingHandler;
    private OutgoingFrames outgoingHandler;
    private UpgradeRequest upgradeRequest;
    private UpgradeResponse upgradeResponse;
    private CompletableFuture<Session> openFuture;

    public WebSocketSession(WebSocketContainerScope containerScope, URI requestURI, EventDriver websocket, LogicalConnection connection) {
        Objects.requireNonNull(containerScope, "Container Scope cannot be null");
        Objects.requireNonNull(requestURI, "Request URI cannot be null");
        this.classLoader = Thread.currentThread().getContextClassLoader();
        this.containerScope = containerScope;
        this.requestURI = requestURI;
        this.websocket = websocket;
        this.connection = connection;
        this.executor = connection.getExecutor();
        this.outgoingHandler = connection;
        this.incomingHandler = websocket;
        this.policy = websocket.getPolicy();
        this.connection.setSession(this);
        this.addBean(this.connection);
        this.addBean(this.websocket);
        this.notifySessionListeners(containerScope, listener -> listener.onSessionCreated(this));
    }

    public void close(Throwable cause) {
        this.connection.close(cause);
    }

    public void close() {
        this.close(new CloseInfo(1000), null);
    }

    public void close(CloseStatus closeStatus) {
        this.close(new CloseInfo(closeStatus.getCode(), closeStatus.getPhrase()), null);
    }

    public void close(int statusCode, String reason) {
        this.close(new CloseInfo(statusCode, reason), null);
    }

    private void close(CloseInfo closeInfo, Callback callback) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("close({})", new Object[]{closeInfo});
        }
        this.connection.close(closeInfo, callback);
    }

    public void disconnect() {
        this.connection.disconnect();
    }

    public void dispatch(Runnable runnable) {
        this.executor.execute(runnable);
    }

    protected void doStart() throws Exception {
        Iterator<RemoteEndpointFactory> iter;
        if (LOG.isDebugEnabled()) {
            LOG.debug("starting - {}", new Object[]{this});
        }
        if ((iter = ServiceLoader.load(RemoteEndpointFactory.class).iterator()).hasNext()) {
            this.remoteEndpointFactory = iter.next();
        }
        if (this.remoteEndpointFactory == null) {
            this.remoteEndpointFactory = this;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Using RemoteEndpointFactory: {}", new Object[]{this.remoteEndpointFactory});
        }
        super.doStart();
    }

    protected void doStop() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("stopping - {}", new Object[]{this});
        }
        this.connection.close(new CloseInfo(1001, "Shutdown"), new DisconnectCallback(this.connection));
        super.doStop();
    }

    public String dumpSelf() {
        return String.format("%s@%x[behavior=%s,batchMode=%s,idleTimeout=%d,requestURI=%s]", this.getClass().getSimpleName(), this.hashCode(), this.getPolicy().getBehavior(), this.getBatchMode(), this.getIdleTimeout(), this.getRequestURI());
    }

    public ByteBufferPool getBufferPool() {
        return this.connection.getBufferPool();
    }

    public ClassLoader getClassLoader() {
        return this.getClass().getClassLoader();
    }

    public LogicalConnection getConnection() {
        return this.connection;
    }

    @Override
    public WebSocketContainerScope getContainerScope() {
        return this.containerScope;
    }

    public ExtensionFactory getExtensionFactory() {
        return this.extensionFactory;
    }

    public long getIdleTimeout() {
        return this.connection.getMaxIdleTimeout();
    }

    @ManagedAttribute(readonly=true)
    public IncomingFrames getIncomingHandler() {
        return this.incomingHandler;
    }

    public InetSocketAddress getLocalAddress() {
        return this.connection.getLocalAddress();
    }

    @ManagedAttribute(readonly=true)
    public OutgoingFrames getOutgoingHandler() {
        return this.outgoingHandler;
    }

    public WebSocketPolicy getPolicy() {
        return this.policy;
    }

    public String getProtocolVersion() {
        return this.protocolVersion;
    }

    public RemoteEndpoint getRemote() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("[{}] {}.getRemote()", new Object[]{this.policy.getBehavior(), this.getClass().getSimpleName()});
        }
        return this.remote;
    }

    public InetSocketAddress getRemoteAddress() {
        return this.remote.getInetSocketAddress();
    }

    public URI getRequestURI() {
        return this.requestURI;
    }

    public UpgradeRequest getUpgradeRequest() {
        return this.upgradeRequest;
    }

    public UpgradeResponse getUpgradeResponse() {
        return this.upgradeResponse;
    }

    @Override
    public WebSocketSession getWebSocketSession() {
        return this;
    }

    public void incomingFrame(Frame frame) {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            if (this.connection.canReadWebSocketFrames()) {
                this.incomingHandler.incomingFrame(frame);
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("Attempt to process frame when in wrong connection state: " + this.connection.toStateString(), (Throwable)new RuntimeException("TRACE"));
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    public void outgoingFrame(Frame frame, WriteCallback callback, BatchMode batchMode) {
        if (this.onCloseCalled.get()) {
            try {
                if (callback != null) {
                    callback.writeFailed((Throwable)new WebSocketException("Session closed"));
                }
            }
            catch (Throwable x) {
                LOG.debug("Exception while notifying failure of callback " + callback, x);
            }
            return;
        }
        this.outgoingHandler.outgoingFrame(frame, callback, batchMode);
    }

    public boolean isOpen() {
        if (this.connection == null) {
            return false;
        }
        return !this.onCloseCalled.get() && this.connection.isOpen();
    }

    public boolean isSecure() {
        if (this.upgradeRequest == null) {
            throw new IllegalStateException("No valid UpgradeRequest yet");
        }
        URI requestURI = this.upgradeRequest.getRequestURI();
        return "wss".equalsIgnoreCase(requestURI.getScheme());
    }

    public void callApplicationOnClose(CloseInfo closeInfo) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("callApplicationOnClose({})", new Object[]{closeInfo});
        }
        if (this.onCloseCalled.compareAndSet(false, true)) {
            try {
                this.websocket.onClose(closeInfo);
            }
            catch (Throwable t) {
                LOG.warn("Exception while notifying onClose", t);
            }
        }
    }

    public void callApplicationOnError(Throwable cause) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("callApplicationOnError()", cause);
        }
        if (this.openFuture != null && !this.openFuture.isDone()) {
            this.openFuture.completeExceptionally(cause);
        }
        if (!this.onCloseCalled.get()) {
            try {
                this.websocket.onError(cause);
            }
            catch (Throwable t) {
                LOG.warn("Exception while notifying onError", t);
            }
        }
    }

    public void onClosed(Connection connection) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("[{}] {}.onSessionClosed()", new Object[]{this.policy.getBehavior(), this.getClass().getSimpleName()});
        }
        if (connection == this.connection) {
            this.connection.disconnect();
            try {
                this.notifySessionListeners(this.containerScope, listener -> listener.onSessionClosed(this));
            }
            catch (Throwable cause) {
                LOG.ignore(cause);
            }
        }
    }

    public void onOpened(Connection connection) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("[{}] {}.onSessionOpened()", new Object[]{this.policy.getBehavior(), this.getClass().getSimpleName()});
        }
        this.open();
    }

    @Override
    public WebSocketRemoteEndpoint newRemoteEndpoint(LogicalConnection connection, OutgoingFrames outgoingFrames, BatchMode batchMode) {
        return new WebSocketRemoteEndpoint(connection, outgoingFrames, this.getBatchMode());
    }

    public void open() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("[{}] {}.open()", new Object[]{this.policy.getBehavior(), this.getClass().getSimpleName()});
        }
        if (this.remote != null) {
            return;
        }
        try (ThreadClassLoaderScope scope = new ThreadClassLoaderScope(this.classLoader);){
            if (this.connection.opening()) {
                this.remote = this.remoteEndpointFactory.newRemoteEndpoint(this.connection, this, this.getBatchMode());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("[{}] {}.open() remote={}", new Object[]{this.policy.getBehavior(), this.getClass().getSimpleName(), this.remote});
                }
                this.websocket.openSession(this);
                if (this.connection.opened()) {
                    try {
                        this.notifySessionListeners(this.containerScope, listener -> listener.onSessionOpened(this));
                    }
                    catch (Throwable t) {
                        LOG.ignore(t);
                    }
                } else {
                    this.callApplicationOnClose(new CloseInfo(1006, "Failed to open local endpoint"));
                    this.disconnect();
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("[{}] open -> {}", new Object[]{this.getPolicy().getBehavior(), this.dump()});
                }
                if (this.openFuture != null) {
                    this.openFuture.complete(this);
                }
            }
        }
        catch (Throwable t) {
            this.close(t);
        }
    }

    public void setExtensionFactory(ExtensionFactory extensionFactory) {
        this.extensionFactory = extensionFactory;
    }

    public void setFuture(CompletableFuture<Session> fut) {
        this.openFuture = fut;
    }

    public void setIdleTimeout(long ms) {
        this.connection.setMaxIdleTimeout(ms);
    }

    public void setOutgoingHandler(OutgoingFrames outgoing) {
        this.outgoingHandler = outgoing;
    }

    @Deprecated
    public void setPolicy(WebSocketPolicy policy) {
    }

    public void setUpgradeRequest(UpgradeRequest request) {
        this.upgradeRequest = request;
        this.protocolVersion = request.getProtocolVersion();
        this.parameterMap.clear();
        if (request.getParameterMap() != null) {
            for (Map.Entry entry : request.getParameterMap().entrySet()) {
                List values = (List)entry.getValue();
                if (values != null) {
                    this.parameterMap.put((String)entry.getKey(), values.toArray(new String[values.size()]));
                    continue;
                }
                this.parameterMap.put((String)entry.getKey(), new String[0]);
            }
        }
    }

    public void setUpgradeResponse(UpgradeResponse response) {
        this.upgradeResponse = response;
    }

    public SuspendToken suspend() {
        if (this.onCloseCalled.get()) {
            throw new IllegalStateException("Not open");
        }
        return this.connection.suspend();
    }

    public BatchMode getBatchMode() {
        return BatchMode.AUTO;
    }

    private void notifySessionListeners(WebSocketContainerScope scope, Consumer<WebSocketSessionListener> consumer) {
        for (WebSocketSessionListener listener : scope.getSessionListeners()) {
            try {
                consumer.accept(listener);
            }
            catch (Throwable x) {
                LOG.info("Exception while invoking listener " + listener, x);
            }
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("WebSocketSession[");
        builder.append("websocket=").append(this.websocket);
        builder.append(",behavior=").append(this.policy.getBehavior());
        builder.append(",connection=").append(this.connection);
        builder.append(",remote=").append(this.remote);
        builder.append(",incoming=").append(this.incomingHandler);
        builder.append(",outgoing=").append(this.outgoingHandler);
        builder.append("]");
        return builder.toString();
    }
}

