/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.jsr356.utils;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class Primitives {
    private static final Map<Class<?>, Class<?>> PRIMITIVE_CLASS_MAP;
    private static final Map<Class<?>, Class<?>> CLASS_PRIMITIVE_MAP;

    public static Class<?> getPrimitiveClass(Class<?> primitiveType) {
        return PRIMITIVE_CLASS_MAP.get(primitiveType);
    }

    public static Set<Class<?>> getPrimitiveClasses() {
        return CLASS_PRIMITIVE_MAP.keySet();
    }

    public static Set<Class<?>> getPrimitives() {
        return PRIMITIVE_CLASS_MAP.keySet();
    }

    public static Class<?> getPrimitiveType(Class<?> primitiveClass) {
        return CLASS_PRIMITIVE_MAP.get(primitiveClass);
    }

    static {
        HashMap<Class<Void>, Class<Object>> primitives = new HashMap<Class<Void>, Class<Object>>();
        primitives.put(Boolean.class, Boolean.TYPE);
        primitives.put(Byte.class, Byte.TYPE);
        primitives.put(Character.class, Character.TYPE);
        primitives.put(Double.class, Double.TYPE);
        primitives.put(Float.class, Float.TYPE);
        primitives.put(Integer.class, Integer.TYPE);
        primitives.put(Long.class, Long.TYPE);
        primitives.put(Short.class, Short.TYPE);
        primitives.put(Void.class, Void.TYPE);
        CLASS_PRIMITIVE_MAP = Collections.unmodifiableMap(primitives);
        HashMap<Class, Class> types = new HashMap<Class, Class>();
        for (Map.Entry classEntry : primitives.entrySet()) {
            types.put((Class)classEntry.getValue(), (Class)classEntry.getKey());
        }
        PRIMITIVE_CLASS_MAP = Collections.unmodifiableMap(types);
    }
}

