/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.reactive.client.internal;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Objects;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.reactive.client.ReactiveRequest;
import org.eclipse.jetty.reactive.client.internal.AbstractSinglePublisher;
import org.reactivestreams.Subscriber;

public class StringContent
extends AbstractSinglePublisher<Content.Chunk>
implements ReactiveRequest.Content {
    private final String mediaType;
    private final Charset encoding;
    private final byte[] bytes;
    private State state = State.INITIAL;

    public StringContent(String string, String mediaType, Charset encoding) {
        this.mediaType = Objects.requireNonNull(mediaType);
        this.encoding = Objects.requireNonNull(encoding);
        this.bytes = string.getBytes(encoding);
    }

    @Override
    public long getLength() {
        return this.bytes.length;
    }

    @Override
    public String getContentType() {
        return this.mediaType + ";charset=" + this.encoding.name();
    }

    @Override
    public boolean rewind() {
        this.state = State.INITIAL;
        return true;
    }

    @Override
    protected void onRequest(Subscriber<? super Content.Chunk> subscriber, long n) {
        switch (this.state) {
            case INITIAL: {
                this.state = State.CONTENT;
                this.emitOnNext(subscriber, Content.Chunk.from((ByteBuffer)ByteBuffer.wrap(this.bytes), (boolean)false));
                break;
            }
            case CONTENT: {
                this.state = State.COMPLETE;
                this.emitOnComplete(subscriber);
                break;
            }
        }
    }

    private static enum State {
        INITIAL,
        CONTENT,
        COMPLETE;

    }
}

