/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.maven.plugin;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.eclipse.jetty.maven.plugin.AbstractUnassembledWebAppMojo;
import org.eclipse.jetty.maven.plugin.QuickStartGenerator;
import org.eclipse.jetty.util.StringUtil;

@Mojo(name="effective-web-xml", requiresDependencyResolution=ResolutionScope.RUNTIME)
public class JettyEffectiveWebXml
extends AbstractUnassembledWebAppMojo {
    @Parameter(defaultValue="${project.build.directory}/effective-web.xml")
    protected File effectiveWebXml;

    @Override
    public void configureWebApp() throws Exception {
        super.configureWebApp();
        if (StringUtil.isBlank((String)this.webApp.getWar())) {
            super.configureUnassembledWebApp();
        }
    }

    @Override
    protected void configureUnassembledWebApp() throws Exception {
    }

    @Override
    protected void startJettyEmbedded() throws MojoExecutionException {
        this.generate();
    }

    @Override
    protected void startJettyForked() throws MojoExecutionException {
        this.generate();
    }

    @Override
    protected void startJettyDistro() throws MojoExecutionException {
        this.generate();
    }

    private void generate() throws MojoExecutionException {
        try {
            QuickStartGenerator generator = new QuickStartGenerator(this.effectiveWebXml, this.webApp);
            generator.generate();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error generating effective web xml", e);
        }
    }
}

