/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Objects;
import org.eclipse.jetty.client.Request;
import org.eclipse.jetty.client.Response;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.io.RetainableByteBuffer;

public abstract class AbstractResponseListener
implements Response.Listener {
    private final RetainableByteBuffer.Mutable accumulator;
    private String encoding;
    private String mediaType;
    private byte[] content;
    private boolean append;

    protected AbstractResponseListener(RetainableByteBuffer.Mutable accumulator) {
        this.accumulator = Objects.requireNonNull(accumulator);
    }

    public long getMaxLength() {
        return this.accumulator.maxSize();
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getMediaType() {
        return this.mediaType;
    }

    @Override
    public void onHeaders(Response response) {
        long maxLength;
        Request request = response.getRequest();
        HttpFields headers = response.getHeaders();
        long length = headers.getLongField(HttpHeader.CONTENT_LENGTH);
        if (HttpMethod.HEAD.is(request.getMethod())) {
            length = 0L;
        }
        if (length > (maxLength = this.getMaxLength())) {
            response.abort(new IllegalArgumentException("Buffering capacity " + maxLength + " exceeded"));
            return;
        }
        String contentType = headers.get(HttpHeader.CONTENT_TYPE);
        if (contentType != null) {
            int semicolon;
            String media = contentType;
            String charset = "charset=";
            int index = contentType.toLowerCase(Locale.ENGLISH).indexOf(charset);
            if (index > 0) {
                media = contentType.substring(0, index);
                String encoding = contentType.substring(index + charset.length());
                int semicolon2 = encoding.indexOf(59);
                if (semicolon2 > 0) {
                    encoding = encoding.substring(0, semicolon2).trim();
                }
                int lastIndex = encoding.length() - 1;
                if (encoding.charAt(0) == '\"' && encoding.charAt(lastIndex) == '\"') {
                    encoding = encoding.substring(1, lastIndex).trim();
                }
                this.encoding = encoding;
            }
            if ((semicolon = media.indexOf(59)) > 0) {
                media = media.substring(0, semicolon).trim();
            }
            this.mediaType = media;
        }
    }

    @Override
    public void onContent(Response response, Content.Chunk chunk, Runnable demander) throws Exception {
        this.onContent(response, chunk.getByteBuffer());
        if (this.append) {
            this.append = false;
            if (this.accumulator.append((RetainableByteBuffer)chunk)) {
                demander.run();
            } else {
                response.abort(new IllegalArgumentException("Buffering capacity " + this.getMaxLength() + " exceeded"));
            }
        } else {
            demander.run();
        }
    }

    @Override
    public void onContent(Response response, ByteBuffer content) {
        this.append = true;
    }

    @Override
    public void onSuccess(Response response) {
        this.content = this.take();
    }

    @Override
    public void onFailure(Response response, Throwable failure) {
        this.accumulator.clear();
    }

    public byte[] getContent() {
        if (this.content == null) {
            this.content = this.take();
        }
        return this.content;
    }

    public String getContentAsString() {
        String encoding = this.getEncoding();
        if (encoding == null) {
            return this.getContentAsString(StandardCharsets.UTF_8);
        }
        return this.getContentAsString(encoding);
    }

    public String getContentAsString(String encoding) {
        return this.getContentAsString(Charset.forName(encoding));
    }

    public String getContentAsString(Charset charset) {
        return new String(this.getContent(), charset);
    }

    public InputStream getContentAsInputStream() {
        return new ByteArrayInputStream(this.getContent());
    }

    private byte[] take() {
        return this.accumulator.takeByteArray();
    }
}

