/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.net.SocketAddress;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jetty.client.AbstractHttpClientTransport;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.io.ClientConnector;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;

@ManagedObject
public abstract class AbstractConnectorHttpClientTransport
extends AbstractHttpClientTransport {
    private final ClientConnector connector;

    protected AbstractConnectorHttpClientTransport(ClientConnector connector) {
        this.connector = Objects.requireNonNull(connector);
        this.installBean(connector);
    }

    public ClientConnector getClientConnector() {
        return this.connector;
    }

    @ManagedAttribute(value="The number of selectors", readonly=true)
    public int getSelectors() {
        return this.connector.getSelectors();
    }

    protected void doStart() throws Exception {
        HttpClient httpClient = this.getHttpClient();
        this.connector.setBindAddress(httpClient.getBindAddress());
        this.connector.setByteBufferPool(httpClient.getByteBufferPool());
        this.connector.setConnectBlocking(httpClient.isConnectBlocking());
        this.connector.setConnectTimeout(Duration.ofMillis(httpClient.getConnectTimeout()));
        this.connector.setExecutor(httpClient.getExecutor());
        this.connector.setIdleTimeout(Duration.ofMillis(httpClient.getIdleTimeout()));
        this.connector.setScheduler(httpClient.getScheduler());
        this.connector.setSslContextFactory(httpClient.getSslContextFactory());
        super.doStart();
    }

    @Override
    public void connect(SocketAddress address, Map<String, Object> context) {
        this.getHttpClient().connect(address, context);
    }
}

