/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.mutable.primitive;

import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.LazyByteIterable;
import org.eclipse.collections.api.block.function.primitive.ByteToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.BytePredicate;
import org.eclipse.collections.api.collection.primitive.MutableByteCollection;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.set.primitive.ByteSet;
import org.eclipse.collections.api.set.primitive.ImmutableByteSet;
import org.eclipse.collections.api.set.primitive.MutableByteSet;
import org.eclipse.collections.impl.collection.mutable.primitive.AbstractSynchronizedByteCollection;
import org.eclipse.collections.impl.lazy.primitive.LazyByteIterableAdapter;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableByteSet;

@ThreadSafe
public final class SynchronizedByteSet
extends AbstractSynchronizedByteCollection
implements MutableByteSet {
    private static final long serialVersionUID = 1L;

    public SynchronizedByteSet(MutableByteSet set) {
        super((MutableByteCollection)set);
    }

    public SynchronizedByteSet(MutableByteSet set, Object newLock) {
        super((MutableByteCollection)set, newLock);
    }

    public static SynchronizedByteSet of(MutableByteSet set) {
        return new SynchronizedByteSet(set);
    }

    public static SynchronizedByteSet of(MutableByteSet set, Object lock) {
        return new SynchronizedByteSet(set, lock);
    }

    @GuardedBy(value="getLock()")
    private MutableByteSet getMutableByteSet() {
        return (MutableByteSet)this.getByteCollection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedByteSet without(byte element) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableByteSet().remove(element);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedByteSet with(byte element) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableByteSet().add(element);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedByteSet withAll(ByteIterable elements) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableByteSet().addAll(elements.toArray());
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedByteSet withoutAll(ByteIterable elements) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableByteSet().removeAll(elements);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableByteSet select(BytePredicate predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableByteSet().select(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableByteSet reject(BytePredicate predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableByteSet().reject(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> MutableSet<V> collect(ByteToObjectFunction<? extends V> function) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableByteSet().collect(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object otherSet) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableByteSet().equals(otherSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableByteSet().hashCode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LazyByteIterable asLazy() {
        Object object = this.getLock();
        synchronized (object) {
            return new LazyByteIterableAdapter((ByteIterable)this);
        }
    }

    public MutableByteSet asUnmodifiable() {
        return new UnmodifiableByteSet(this);
    }

    public MutableByteSet asSynchronized() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteSet freeze() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableByteSet().freeze();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableByteSet toImmutable() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableByteSet().toImmutable();
        }
    }
}

